/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.consumer;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public final class RecordingInput
implements DataInput,
AutoCloseable {
    public static final byte STRING_ENCODING_NULL = 0;
    public static final byte STRING_ENCODING_EMPTY_STRING = 1;
    public static final byte STRING_ENCODING_CONSTANT_POOL = 2;
    public static final byte STRING_ENCODING_UTF8_BYTE_ARRAY = 3;
    public static final byte STRING_ENCODING_CHAR_ARRAY = 4;
    public static final byte STRING_ENCODING_LATIN1_BYTE_ARRAY = 5;
    private static final int DEFAULT_BLOCK_SIZE = 0x1000000;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset LATIN1 = Charset.forName("ISO-8859-1");
    private final RandomAccessFile file;
    private final long size;
    private Block currentBlock = new Block();
    private Block previousBlock = new Block();
    private long position;
    private final int blockSize;

    private RecordingInput(File file, int n) throws IOException {
        this.size = file.length();
        this.blockSize = n;
        this.file = new RandomAccessFile(file, "r");
        if (this.size < 8L) {
            throw new IOException("Not a valid Flight Recorder file. File length is only " + this.size + " bytes.");
        }
    }

    public RecordingInput(File file) throws IOException {
        this(file, 0x1000000);
    }

    @Override
    public final byte readByte() throws IOException {
        if (!this.currentBlock.contains(this.position)) {
            this.position(this.position);
        }
        return this.currentBlock.get(this.position++);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = this.readByte();
        }
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final short readRawShort() throws IOException {
        byte by = this.readByte();
        byte by2 = this.readByte();
        return (short)((by2 & 0xFF) + (by << 8));
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawInt());
    }

    public final int readRawInt() throws IOException {
        byte by = this.readByte();
        byte by2 = this.readByte();
        byte by3 = this.readByte();
        byte by4 = this.readByte();
        return (by4 & 0xFF) + ((by3 & 0xFF) << 8) + ((by2 & 0xFF) << 16) + (by << 24);
    }

    public final long readRawLong() throws IOException {
        byte by = this.readByte();
        byte by2 = this.readByte();
        byte by3 = this.readByte();
        byte by4 = this.readByte();
        byte by5 = this.readByte();
        byte by6 = this.readByte();
        byte by7 = this.readByte();
        byte by8 = this.readByte();
        return ((long)by8 & 0xFFL) + (((long)by7 & 0xFFL) << 8) + (((long)by6 & 0xFFL) << 16) + (((long)by5 & 0xFFL) << 24) + (((long)by4 & 0xFFL) << 32) + (((long)by3 & 0xFFL) << 40) + (((long)by2 & 0xFFL) << 48) + ((long)by << 56);
    }

    public final long position() throws IOException {
        return this.position;
    }

    public final void position(long l) throws IOException {
        if (!this.currentBlock.contains(l)) {
            if (!this.previousBlock.contains(l)) {
                if (l > this.size()) {
                    throw new EOFException("Trying to read at " + l + ", but file is only " + this.size() + " bytes.");
                }
                long l2 = this.trimToFileSize(this.calculateBlockStart(l));
                this.file.seek(l2);
                long l3 = Math.min(this.size() - l2, (long)this.blockSize);
                this.previousBlock.read(this.file, (int)l3);
            }
            Block block = this.currentBlock;
            this.currentBlock = this.previousBlock;
            this.previousBlock = block;
        }
        this.position = l;
    }

    private final long trimToFileSize(long l) throws IOException {
        return Math.min(this.size(), Math.max(0L, l));
    }

    private final long calculateBlockStart(long l) {
        if (this.currentBlock.contains(l - (long)this.blockSize)) {
            return this.currentBlock.blockPosition + (long)this.currentBlock.bytes.length;
        }
        if (this.currentBlock.contains(l + (long)this.blockSize)) {
            return this.currentBlock.blockPosition - (long)this.blockSize;
        }
        return l - (long)(this.blockSize / 2);
    }

    public final long size() throws IOException {
        return this.size;
    }

    @Override
    public final void close() throws IOException {
        this.file.close();
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        long l = this.position();
        this.position(l + (long)n);
        return (int)(this.position() - l);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readEncodedString(this.readByte());
    }

    public String readEncodedString(byte by) throws IOException {
        if (by == 0) {
            return null;
        }
        if (by == 1) {
            return "";
        }
        int n = this.readInt();
        this.require(n, "String size %d exceeds available data");
        if (by == 4) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.readChar();
            }
            return new String(cArray);
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        if (by == 3) {
            return new String(byArray, UTF8);
        }
        if (by == 5) {
            return new String(byArray, LATIN1);
        }
        throw new IOException("Unknown string encoding " + by);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    @Override
    public long readLong() throws IOException {
        byte by = this.readByte();
        long l = (long)by & 0x7FL;
        if (by >= 0) {
            return l;
        }
        byte by2 = this.readByte();
        l += ((long)by2 & 0x7FL) << 7;
        if (by2 >= 0) {
            return l;
        }
        byte by3 = this.readByte();
        l += ((long)by3 & 0x7FL) << 14;
        if (by3 >= 0) {
            return l;
        }
        byte by4 = this.readByte();
        l += ((long)by4 & 0x7FL) << 21;
        if (by4 >= 0) {
            return l;
        }
        byte by5 = this.readByte();
        l += ((long)by5 & 0x7FL) << 28;
        if (by5 >= 0) {
            return l;
        }
        byte by6 = this.readByte();
        l += ((long)by6 & 0x7FL) << 35;
        if (by6 >= 0) {
            return l;
        }
        byte by7 = this.readByte();
        l += ((long)by7 & 0x7FL) << 42;
        if (by7 >= 0) {
            return l;
        }
        byte by8 = this.readByte();
        l += ((long)by8 & 0x7FL) << 49;
        if (by8 >= 0) {
            return l;
        }
        byte by9 = this.readByte();
        return l + ((long)(by9 & 0xFF) << 56);
    }

    public void require(int n, String string) throws IOException {
        if (this.position + (long)n > this.size) {
            throw new IOException(String.format(string, n));
        }
    }

    private static final class Block {
        private byte[] bytes = new byte[0];
        private long blockPosition;

        private Block() {
        }

        boolean contains(long l) {
            return l >= this.blockPosition && l < this.blockPosition + (long)this.bytes.length;
        }

        public void read(RandomAccessFile randomAccessFile, int n) throws IOException {
            this.blockPosition = randomAccessFile.getFilePointer();
            if (n != this.bytes.length) {
                this.bytes = new byte[n];
            }
            randomAccessFile.readFully(this.bytes);
        }

        public byte get(long l) {
            return this.bytes[(int)(l - this.blockPosition)];
        }
    }
}

