/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private final boolean initialized;
    private final Map<String, ProtectionDomain> pdcache = new ConcurrentHashMap<String, ProtectionDomain>(11);
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected SecureClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, CodeSource codeSource) {
        return this.defineClass(string, byteBuffer, this.getProtectionDomain(codeSource));
    }

    protected final Class<?> defineClassFromCDS(String string, long l, CodeSource codeSource) {
        return this.defineClassFromCDS(string, l, this.getProtectionDomain(codeSource));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        this.check();
        return new Permissions();
    }

    public ProtectionDomain getProtectionDomain(final CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        String string = codeSource.getLocationNoFragString();
        if (string == null) {
            string = "<null>";
        }
        return this.pdcache.computeIfAbsent(string, new Function<String, ProtectionDomain>(){

            @Override
            public ProtectionDomain apply(String string) {
                PermissionCollection permissionCollection = SecureClassLoader.this.getPermissions(codeSource);
                ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, permissionCollection, SecureClassLoader.this, null);
                if (debug != null) {
                    debug.println(" getPermissions " + protectionDomain);
                    debug.println("");
                }
                return protectionDomain;
            }
        });
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

