/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import sun.misc.JavaLangClassLoaderAccess;
import sun.misc.SharedSecrets;

public class Utils {
    private static JavaLangClassLoaderAccess JLCA = SharedSecrets.getJavaLangClassLoaderAccess();
    private static Map<Integer, WeakReference<ClassLoader>> hash2Loader = new ConcurrentHashMap<Integer, WeakReference<ClassLoader>>();
    private static final String CP_FLAG = "-Djava.class.path";
    private static final String JAVA_COMMAND_FLAG = "-Dsun.java.command";
    private static final String JAVA_LAUNCHER_FLAG = "-Dsun.java.launcher";
    public static final String JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    private static File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static int calculateSignatureForName(String string) {
        return string.hashCode();
    }

    public static void registerClassLoader(ClassLoader classLoader, String string) {
        if (string == null || classLoader == null) {
            throw new IllegalArgumentException("[Register CL Exception] identifier or loader is null");
        }
        try {
            Utils.registerClassLoader(classLoader, Utils.calculateSignatureForName(string));
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("[Register CL Exception] the identifier " + string + " with signature: " + Integer.toHexString(Utils.calculateSignatureForName(string)) + " has already bean registered for loader " + classLoader);
        }
    }

    public static synchronized void registerClassLoader(ClassLoader classLoader, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("[Register CL Exception] signature is zero");
        }
        if (JLCA.getSignature(classLoader) != 0) {
            throw new IllegalStateException("[Register CL Exception] loader with signature " + Integer.toHexString(n) + " has already bean registered");
        }
        if (hash2Loader.containsKey(n)) {
            throw new IllegalStateException("[Register CL Exception] has conflict: " + Integer.toHexString(n) + " for loader " + classLoader);
        }
        hash2Loader.put(n, new WeakReference<ClassLoader>(classLoader));
        JLCA.setSignature(classLoader, n);
    }

    public static WeakReference<ClassLoader> getClassLoader(int n) {
        return hash2Loader.get(n);
    }

    public static void printArgs(List<String> list, String string, boolean bl) {
        if (!bl) {
            return;
        }
        System.out.println();
        System.out.println(string);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            System.out.println("[" + i + "] " + string2);
        }
        System.out.println();
    }

    public static String removeAgentOp() {
        String string = System.getenv(JAVA_TOOL_OPTIONS);
        return string == null ? null : string.replaceAll("-javaagent\\S*\\s?", " ");
    }

    public static void runProcess(List<String> list, boolean bl, Consumer<ProcessBuilder> consumer) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(list).inheritIO();
        if (consumer != null) {
            consumer.accept(processBuilder);
        }
        if (bl) {
            processBuilder.redirectErrorStream(true);
        } else {
            processBuilder.redirectOutput(NULL_FILE);
        }
        Process process = processBuilder.start();
        int n = process.waitFor();
        boolean bl2 = n != 0;
        if (bl2 || bl) {
            System.out.println("return value: " + n);
            if (bl2) {
                throw new Exception("Process failed");
            }
        }
    }

    public static void runProcess(boolean bl, String string, Consumer<ProcessBuilder> consumer, String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        Utils.printArgs(list, string, bl);
        try {
            Utils.runProcess(list, bl, consumer);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public static String getJDKHome() {
        String string = System.getProperty("java.home");
        if (!new File(string).exists()) {
            throw new Error("Fatal error, cannot find jdk path: [" + string + "] doesn't exist!");
        }
        return string;
    }

    public static String[] getCommandLine() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ArrayList<String> arrayList = new ArrayList<String>(runtimeMXBean.getInputArguments());
        arrayList.add("-classpath");
        arrayList.add(System.getProperty("java.class.path"));
        return arrayList.toArray(new String[0]);
    }

    public static String getVMRuntimeArguments(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (String string2 : stringArray) {
            if (string2.startsWith(CP_FLAG) || string2.startsWith(JAVA_COMMAND_FLAG) || string2.startsWith(JAVA_LAUNCHER_FLAG)) continue;
            arrayList.addAll(Arrays.stream(string2.split("\\s+")).filter(string -> string.startsWith("-")).collect(Collectors.toList()));
        }
        return arrayList.stream().collect(Collectors.joining(" "));
    }
}

