/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.ResourceType;
import com.alibaba.rcm.internal.AbstractResourceContainer;
import com.alibaba.tenant.JGroup;
import com.alibaba.tenant.JGroupConstraint;
import com.alibaba.tenant.TenantContainer;
import com.alibaba.tenant.TenantGlobals;
import com.alibaba.tenant.TenantResourceType;
import com.alibaba.tenant.TenantState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class TenantResourceContainer
extends AbstractResourceContainer {
    private final Map<ResourceType, Constraint> constraints;
    private TenantResourceContainer parent;
    private TenantContainer tenant;
    private volatile JGroup jgroup;

    TenantResourceContainer(TenantResourceContainer tenantResourceContainer, TenantContainer tenantContainer, Iterable<Constraint> iterable) {
        this.parent = tenantResourceContainer;
        this.constraints = new HashMap<ResourceType, Constraint>();
        this.tenant = tenantContainer;
        if (iterable != null) {
            iterable.forEach(constraint -> this.constraints.put(constraint.getResourceType(), (Constraint)constraint));
        }
        this.init();
    }

    private void init() {
        if (TenantGlobals.isCpuThrottlingEnabled() || TenantGlobals.isCpuAccountingEnabled()) {
            if (this.constraints.containsKey(ResourceType.CPU_PERCENT)) {
                Constraint constraint = TenantResourceContainer.translate(this.constraints.remove(ResourceType.CPU_PERCENT));
                this.constraints.put(constraint.getResourceType(), constraint);
            }
            this.jgroup = new JGroup(this);
        }
    }

    private static Constraint translate(Constraint constraint) {
        if (constraint.getResourceType() == ResourceType.CPU_PERCENT) {
            long l = Long.parseLong(JGroup.jvmGroup().getValue("cpu.cfs_period_us"));
            long l2 = l * constraint.getValues()[0] / 100L;
            return TenantResourceType.CPU_CFS.newConstraint(l, l2);
        }
        return constraint;
    }

    TenantResourceContainer getParent() {
        return this.parent;
    }

    JGroup getJGroup() {
        return this.jgroup;
    }

    TenantContainer getTenant() {
        return this.tenant;
    }

    @Override
    public Properties getProperties() {
        return this.tenant.getProperties();
    }

    @Override
    public void setProperties(Properties properties) {
        this.tenant.setProperties(properties);
    }

    @Override
    protected void attach() {
        if (this.jgroup != null) {
            this.jgroup.attach();
        }
        super.attach();
    }

    @Override
    protected void detach() {
        super.detach();
        if (this.jgroup != null) {
            this.jgroup.detach();
        }
    }

    @Override
    public List<Long> getActiveContainerThreadIds() {
        throw new UnsupportedOperationException("Should not call getActiveTenantThreadIds");
    }

    @Override
    public void run(Runnable runnable) {
        if (this.tenant.getState() == TenantState.STARTING) {
            this.tenant.setState(TenantState.RUNNING);
        }
        super.run(runnable);
    }

    @Override
    public ResourceContainer.State getState() {
        return TenantState.translate(this.tenant.getState());
    }

    @Override
    public void updateConstraint(Constraint constraint) {
        TenantResourceType tenantResourceType;
        Constraint constraint2 = TenantResourceContainer.translate(constraint);
        if (constraint2.getResourceType() instanceof TenantResourceType && (tenantResourceType = (TenantResourceType)constraint2.getResourceType()).isJGroupResource() && this.jgroup != null) {
            ((JGroupConstraint)constraint2).sync(this.jgroup);
        }
        this.constraints.put(constraint2.getResourceType(), constraint2);
    }

    @Override
    public Iterable<Constraint> getConstraints() {
        return this.constraints.values();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException("Should not call TenantResourceContainer::destroy() directly");
    }

    @Override
    public Long getConsumedAmount(ResourceType resourceType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getResourceLimitReachedCount(ResourceType resourceType) {
        throw new UnsupportedOperationException();
    }

    void destroyImpl() {
        if (this.jgroup != null) {
            this.jgroup.destory();
            this.jgroup = null;
        }
        this.parent = null;
        this.tenant = null;
    }

    long getProcessCpuTime() {
        if (this.jgroup != null) {
            return this.jgroup.getCpuTime();
        }
        return 0L;
    }
}

