/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.Period;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.Cutoff;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.EventHandlerCreator;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.SettingsManager;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;

public final class MetadataRepository {
    private static final JVM jvm = JVM.getJVM();
    private static final MetadataRepository instace = new MetadataRepository();
    private final List<EventType> nativeEventTypes = new ArrayList<EventType>(100);
    private final List<EventControl> nativeControls = new ArrayList<EventControl>(100);
    private final TypeLibrary typeLibrary = TypeLibrary.getInstance();
    private final SettingsManager settingsManager = new SettingsManager();
    private boolean staleMetadata = true;
    private boolean unregistered;
    private long lastUnloaded = -1L;

    public MetadataRepository() {
        this.initializeJVMEventTypes();
    }

    private void initializeJVMEventTypes() {
        ArrayList<RequestEngine.RequestHook> arrayList = new ArrayList<RequestEngine.RequestHook>();
        for (Type type : this.typeLibrary.getTypes()) {
            if (!(type instanceof PlatformEventType)) continue;
            PlatformEventType platformEventType = (PlatformEventType)type;
            EventType eventType = PrivateAccess.getInstance().newEventType(platformEventType);
            platformEventType.setHasDuration(eventType.getAnnotation(Threshold.class) != null);
            platformEventType.setHasStackTrace(eventType.getAnnotation(StackTrace.class) != null);
            platformEventType.setHasCutoff(eventType.getAnnotation(Cutoff.class) != null);
            platformEventType.setHasPeriod(eventType.getAnnotation(Period.class) != null);
            if (platformEventType.hasPeriod()) {
                platformEventType.setEventHook(true);
                if (!"jdk.ExecutionSample".equals(type.getName())) {
                    arrayList.add(new RequestEngine.RequestHook(platformEventType));
                }
            }
            this.nativeControls.add(new EventControl(platformEventType));
            this.nativeEventTypes.add(eventType);
        }
        RequestEngine.addHooks(arrayList);
    }

    public static MetadataRepository getInstance() {
        return instace;
    }

    public synchronized List<EventType> getRegisteredEventTypes() {
        List<EventHandler> list = MetadataRepository.getEventHandlers();
        ArrayList<EventType> arrayList = new ArrayList<EventType>(list.size() + this.nativeEventTypes.size());
        for (EventHandler eventHandler : list) {
            if (!eventHandler.isRegistered()) continue;
            arrayList.add(eventHandler.getEventType());
        }
        arrayList.addAll(this.nativeEventTypes);
        return arrayList;
    }

    public synchronized EventType getEventType(Class<? extends Event> clazz) {
        EventHandler eventHandler = this.getHandler(clazz);
        if (eventHandler != null && eventHandler.isRegistered()) {
            return eventHandler.getEventType();
        }
        throw new IllegalStateException("Event class " + clazz.getName() + " is not registered");
    }

    public synchronized void unregister(Class<? extends Event> clazz) {
        Utils.checkRegisterPermission();
        EventHandler eventHandler = this.getHandler(clazz);
        if (eventHandler != null) {
            eventHandler.setRegistered(false);
        }
    }

    public synchronized EventType register(Class<? extends Event> clazz) {
        return this.register(clazz, Collections.emptyList(), Collections.emptyList());
    }

    public synchronized EventType register(Class<? extends Event> clazz, List<AnnotationElement> list, List<ValueDescriptor> list2) {
        Utils.checkRegisterPermission();
        EventHandler eventHandler = this.getHandler(clazz);
        if (eventHandler == null) {
            eventHandler = this.makeHandler(clazz, list, list2);
        }
        eventHandler.setRegistered(true);
        this.typeLibrary.addType(eventHandler.getPlatformEventType());
        if (jvm.isRecording()) {
            this.storeDescriptorInJVM();
            this.settingsManager.setEventControl(eventHandler.getEventControl());
            this.settingsManager.updateRetransform(Collections.singletonList(clazz));
        } else {
            this.setStaleMetadata();
        }
        return eventHandler.getEventType();
    }

    private EventHandler getHandler(Class<? extends Event> clazz) {
        Utils.ensureValidEventSubclass(clazz);
        SecuritySupport.makeVisibleToJFR(clazz);
        Utils.ensureInitialized(clazz);
        return Utils.getHandler(clazz);
    }

    private EventHandler makeHandler(Class<? extends Event> clazz, List<AnnotationElement> list, List<ValueDescriptor> list2) throws InternalError {
        Object object;
        SecuritySupport.addHandlerExport(clazz);
        PlatformEventType platformEventType = (PlatformEventType)TypeLibrary.createType(clazz, list, list2);
        EventType eventType = PrivateAccess.getInstance().newEventType(platformEventType);
        EventControl eventControl = new EventControl(platformEventType, clazz);
        Class<EventHandler> clazz2 = null;
        try {
            object = EventHandlerCreator.makeEventHandlerName(eventType.getId());
            clazz2 = Class.forName((String)object, false, Event.class.getClassLoader()).asSubclass(EventHandler.class);
            platformEventType.setInstrumented();
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, "Found existing event handler for " + eventType.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            EventHandlerCreator eventHandlerCreator = new EventHandlerCreator(eventType.getId(), eventControl.getSettingInfos(), eventType, clazz);
            clazz2 = eventHandlerCreator.makeEventHandlerClass();
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, "Created event handler for " + eventType.getName());
        }
        object = EventHandlerCreator.instantiateEventHandler(clazz2, true, eventType, eventControl);
        Utils.setHandler(clazz, (EventHandler)object);
        return object;
    }

    public synchronized void setSettings(List<Map<String, String>> list) {
        this.settingsManager.setSettings(list);
    }

    synchronized void disableEvents() {
        for (EventControl eventControl : this.getEventControls()) {
            eventControl.disable();
        }
    }

    public synchronized List<EventControl> getEventControls() {
        ArrayList<EventControl> arrayList = new ArrayList<EventControl>();
        arrayList.addAll(this.nativeControls);
        for (EventHandler eventHandler : MetadataRepository.getEventHandlers()) {
            arrayList.add(eventHandler.getEventControl());
        }
        return arrayList;
    }

    private void storeDescriptorInJVM() throws InternalError {
        jvm.storeMetadataDescriptor(this.getBinaryRepresentation());
        this.staleMetadata = false;
    }

    private static List<EventHandler> getEventHandlers() {
        List<Class<? extends Event>> list = jvm.getAllEventClasses();
        ArrayList<EventHandler> arrayList = new ArrayList<EventHandler>(list.size());
        for (Class<? extends Event> clazz : list) {
            EventHandler eventHandler = Utils.getHandler(clazz);
            if (eventHandler == null) continue;
            arrayList.add(eventHandler);
        }
        return arrayList;
    }

    private byte[] getBinaryRepresentation() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(40000);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            List<Type> list = this.typeLibrary.getTypes();
            Collections.sort(list);
            MetadataDescriptor.write(list, dataOutputStream);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError(iOException);
        }
    }

    synchronized boolean isEnabled(String string) {
        return this.settingsManager.isEnabled(string);
    }

    synchronized void setStaleMetadata() {
        this.staleMetadata = true;
    }

    synchronized void setOutput(String string) {
        if (this.staleMetadata) {
            this.storeDescriptorInJVM();
        }
        jvm.setOutput(string);
        this.unregisterUnloaded();
        if (this.unregistered) {
            if (this.typeLibrary.clearUnregistered()) {
                this.storeDescriptorInJVM();
            }
            this.unregistered = false;
        }
    }

    private void unregisterUnloaded() {
        long l = jvm.getUnloadedEventClassCount();
        if (this.lastUnloaded != l) {
            this.lastUnloaded = l;
            List<Class<? extends Event>> list = jvm.getAllEventClasses();
            HashSet<Long> hashSet = new HashSet<Long>(list.size());
            for (Class<? extends Event> object : list) {
                hashSet.add(Type.getTypeId(object));
            }
            for (Type type : this.typeLibrary.getTypes()) {
                PlatformEventType platformEventType;
                if (!(type instanceof PlatformEventType) || hashSet.contains(type.getId()) || (platformEventType = (PlatformEventType)type).isJVM()) continue;
                platformEventType.setRegistered(false);
            }
        }
    }

    public synchronized void setUnregistered() {
        this.unregistered = true;
    }
}

