/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension5;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceAcquirer;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContextListener;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.DefaultServerOutputReader;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLQueryTransformer;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.jobs.DataSourceMonitorJob;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceSystemAgent;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.CompositeSelectionProvider;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.TabFolderReorder;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetProvider;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.EditorPartContextualProperty;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IActionContributor;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.IStatefulEditor;
import org.jkiss.dbeaver.ui.editors.IncludedScriptFileEditorInput;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.ExtraPresentationManager;
import org.jkiss.dbeaver.ui.editors.sql.MultiTabsQueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.MultiTabsQueryResultsContainer;
import org.jkiss.dbeaver.ui.editors.sql.QueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.QueryResultsContainer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorFeatures;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputConsoleViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorParametersProvider;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLScriptBindingType;
import org.jkiss.dbeaver.ui.editors.sql.SingleTabQueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddIn;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddInDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddInsRegistry;
import org.jkiss.dbeaver.ui.editors.sql.commands.MultipleResultsPerTabMenuContribution;
import org.jkiss.dbeaver.ui.editors.sql.execute.SQLQueryJob;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.log.SQLLogPanel;
import org.jkiss.dbeaver.ui.editors.sql.plan.ExplainPlanViewer;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationPanelDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationRegistry;
import org.jkiss.dbeaver.ui.editors.sql.scripts.ScriptsHandlerImpl;
import org.jkiss.dbeaver.ui.editors.sql.suggestion.SQLSuggestionTextPainter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLEditorCompletionContext;
import org.jkiss.dbeaver.ui.editors.sql.variables.AssignVariableAction;
import org.jkiss.dbeaver.ui.editors.sql.variables.SQLVariablesPanel;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.utils.DataSourceUtils;
import org.jkiss.dbeaver.utils.DurationFormat;
import org.jkiss.dbeaver.utils.DurationFormatter;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SQLEditor
extends SQLEditorBase
implements IDataSourceContainerUpdate,
DBPEventListener,
ISaveablePart2,
DBPDataSourceTask,
DBPDataSourceAcquirer,
IResultSetProvider,
ISmartTransactionManager,
IStatefulEditor {
    private static final long SCRIPT_UI_UPDATE_PERIOD = 100L;
    private static final String PANEL_ITEM_PREFIX = "SQLPanelToggle:";
    private static final String EMBEDDED_BINDING_PREFIX = "-- CONNECTION: ";
    private static final Pattern EMBEDDED_BINDING_PREFIX_PATTERN = Pattern.compile("--\\s*CONNECTION:\\s*(.+)", 2);
    static final Image IMG_DATA_GRID = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID);
    static final Image IMG_DATA_GRID_LOCKED = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID_LOCKED);
    private static final Image IMG_EXPLAIN_PLAN = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_EXPLAIN_PLAN);
    private static final Image IMG_LOG = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_LOG);
    private static final Image IMG_VARIABLES = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_VARIABLE);
    private static final Image IMG_OUTPUT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT);
    private static final Image IMG_OUTPUT_ALERT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT_ALERT);
    private static final String SIDE_TOP_TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.editors.sql.toolbar.side.top";
    private static final String SIDE_BOTTOM_TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.editors.sql.toolbar.side.bottom";
    private static final String MULTIPLE_RESULTS_PER_TAB_PROPERTY = "org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab.isEnabled";
    private static final QualifiedName MULTIPLE_RESULTS_PER_TAB_PROP_NAME = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab.isEnabled");
    public static final String VIEW_PART_PROP_NAME = "org.jkiss.dbeaver.ui.editors.sql.SQLEditor";
    public static final String DEFAULT_TITLE_PATTERN = "<${connectionName}> ${fileName}";
    public static final String DEFAULT_SCRIPT_FILE_NAME = "Script";
    private static final EditorPartContextualProperty multipleResultsPerTabProperty = EditorPartContextualProperty.setup((String)"org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab.isEnabled", (QualifiedName)MULTIPLE_RESULTS_PER_TAB_PROP_NAME, (String)"SQLEditor.resultSet.multipleResultsPerTab", (String)CommonUtils.toString((Object)false));
    private static volatile TransactionStatusUpdateJob transactionStatusUpdateJob;
    static final String STATS_CATEGORY_TRANSACTION_TIMEOUT = "TransactionTimeout";
    private ResultSetOrientation resultSetOrientation = ResultSetOrientation.HORIZONTAL;
    private CustomSashForm resultsSash;
    private Composite sqlEditorPanel;
    @Nullable
    private Composite presentationStack;
    private SashForm sqlExtraPanelSash;
    private CTabFolder sqlExtraPanelFolder;
    private ToolBarManager sqlExtraPanelToolbar;
    private CTabFolder resultTabs;
    private TabFolderReorder resultTabsReorder;
    private CTabItem activeResultsTab;
    private SQLLogPanel logViewer;
    private SQLEditorOutputViewer outputViewer;
    private SQLVariablesPanel variablesViewer;
    @Nullable
    private QueryProcessor curQueryProcessor;
    final List<QueryProcessor> queryProcessors = new ArrayList<QueryProcessor>();
    private DBPDataSourceContainer dataSourceContainer;
    private DBPDataSource curDataSource;
    private volatile DBCExecutionContext isolatedExecutionContext;
    private volatile DBCExecutionContext lastExecutionContext;
    private volatile DBPContextProvider executionContextProvider;
    private SQLScriptContext globalScriptContext;
    private volatile boolean syntaxLoaded = false;
    private final FindReplaceTarget findReplaceTarget = new FindReplaceTarget();
    private final List<SQLQuery> runningQueries = new ArrayList<SQLQuery>();
    private QueryResultsContainer curResultsContainer;
    private Image baseEditorImage;
    private Image editorImage;
    private Image tmpImage;
    private ToolBarManager topBarMan;
    private ToolBarManager bottomBarMan;
    private VerticalFolder presentationSwitchFolder;
    private VerticalButton switchPresentationSQLButton;
    private VerticalButton[] switchPresentationExtraButtons;
    private ExtraPresentationManager extraPresentationManager;
    private final List<SQLEditorListener> listeners = new ArrayList<SQLEditorListener>();
    private final List<ServerOutputInfo> serverOutputs = new ArrayList<ServerOutputInfo>();
    private ScriptAutoSaveJob scriptAutoSavejob;
    private boolean isResultSetAutoFocusEnabled = true;
    private boolean isShowScriptRulerOnExecution = true;
    private Boolean isDisableFetchResultSet = null;
    private boolean datasourceChanged;
    private volatile boolean isPartControlInitialized = false;
    private final ArrayList<SQLEditorAddIn> addIns = new ArrayList();
    private SQLSuggestionTextPainter suggestionTextPainter;
    final DisposeListener resultTabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            Object data = e.widget.getData();
            if (data instanceof QueryResultsContainer) {
                QueryResultsContainer queryResultsContainer = (QueryResultsContainer)data;
                QueryProcessor processor = queryResultsContainer.queryProcessor;
                List<QueryResultsContainer> containers = processor.getResultContainers();
                for (int index = containers.indexOf(data) + 1; index < containers.size(); ++index) {
                    QueryResultsContainer container = containers.get(index);
                    if (container.resultSetNumber != index) continue;
                    --container.resultSetNumber;
                }
            }
            if (SQLEditor.this.resultTabs.getItemCount() == 0 && SQLEditor.this.resultsSash.getMaximizedControl() == null) {
                SQLEditor.this.toggleResultPanel(false, true);
            }
        }
    };

    public SQLSuggestionTextPainter getSuggestionTextPainter() {
        return this.suggestionTextPainter;
    }

    public void removeResults(QueryResultsContainer resultsContainer, boolean removeProcessor) {
        if (resultsContainer == this.curResultsContainer) {
            this.curResultsContainer = null;
        }
        if (removeProcessor) {
            QueryProcessor queryProcessor = resultsContainer.getQueryProcessor();
            this.queryProcessors.remove(queryProcessor);
            if (this.curQueryProcessor == queryProcessor) {
                if (this.queryProcessors.isEmpty()) {
                    this.curQueryProcessor = null;
                    this.curResultsContainer = null;
                } else {
                    this.curQueryProcessor = this.queryProcessors.getFirst();
                    this.curResultsContainer = this.curQueryProcessor.getFirstResults();
                }
            }
        }
    }

    public String toString() {
        return "SQLEditor " + String.valueOf(this.getEditorInput());
    }

    @Nullable
    Composite getPresentationStack() {
        return this.presentationStack;
    }

    VerticalFolder getPresentationSwitchFolder() {
        return this.presentationSwitchFolder;
    }

    public void setResultSetAutoFocusEnabled(boolean value) {
        this.isResultSetAutoFocusEnabled = value;
    }

    public boolean getShowScriptRulerOnExecution() {
        return this.isShowScriptRulerOnExecution;
    }

    public void setShowScriptRulerOnExecution(boolean value) {
        this.isShowScriptRulerOnExecution = value;
    }

    public Boolean getDisableFetchResultSet() {
        return this.isDisableFetchResultSet;
    }

    public void setDisableFetchResultSet(Boolean disableFetchResultSet) {
        this.isDisableFetchResultSet = disableFetchResultSet;
    }

    @Override
    protected String[] getKeyBindingContexts() {
        return new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.script", "org.jkiss.dbeaver.ui.context.resultset", "org.jkiss.dbeaver.ui.editors.sql.script.focused"};
    }

    @Override
    @Nullable
    public DBPDataSource getDataSource() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container == null ? null : container.getDataSource();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        if (this.isolatedExecutionContext != null) {
            return this.isolatedExecutionContext;
        }
        if (this.executionContextProvider != null) {
            return this.executionContextProvider.getExecutionContext();
        }
        if (this.dataSourceContainer != null && !SQLEditorUtils.isOpenSeparateConnection(this.dataSourceContainer)) {
            return DBUtils.getDefaultContext((DBSObject)this.getDataSource(), (boolean)false);
        }
        return null;
    }

    @Override
    @Nullable
    protected DBPDataSourceContainer getDataSourceContainerForSyntaxRuleReloading() {
        return this.dataSourceContainer;
    }

    public SQLScriptContext getGlobalScriptContext() {
        return this.globalScriptContext;
    }

    @Nullable
    public DBPProject getProject() {
        IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        return file == null ? DBWorkbench.getPlatform().getWorkspace().getActiveProject() : DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
    }

    private boolean isProjectResourceEditable() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            DBPProject project = this.getProject();
            return project == null || project.hasRealmPermission("project-resource-edit");
        }
        return true;
    }

    @Override
    protected boolean isReadOnly() {
        return super.isReadOnly() || !this.isProjectResourceEditable();
    }

    public boolean isEditable() {
        return super.isEditable() && this.isProjectResourceEditable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public int[] getCurrentLines() {
        List<SQLQuery> list = this.runningQueries;
        synchronized (list) {
            IDocument document = this.getDocument();
            if (document == null || this.runningQueries.isEmpty()) {
                return null;
            }
            ArrayList<Integer> lines = new ArrayList<Integer>(this.runningQueries.size() * 2);
            for (SQLQuery statementInfo : this.runningQueries) {
                try {
                    int firstLine = document.getLineOfOffset(statementInfo.getOffset());
                    int lastLine = document.getLineOfOffset(statementInfo.getOffset() + statementInfo.getLength());
                    for (int k = firstLine; k <= lastLine; ++k) {
                        lines.add(k);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
            }
            if (lines.isEmpty()) {
                return null;
            }
            int[] results = new int[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                results[i] = (Integer)lines.get(i);
            }
            return results;
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public boolean setDataSourceContainer(@Nullable DBPDataSourceContainer container) {
        IEditorInput input;
        if (container == this.dataSourceContainer) {
            return false;
        }
        if (!this.datasourceChanged && this.curDataSource != null) {
            this.datasourceChanged = true;
        }
        this.releaseContainer();
        this.closeAllJobs();
        this.dataSourceContainer = container;
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
        }
        if ((input = this.getEditorInput()) != null) {
            DBPDataSourceContainer savedContainer = EditorUtils.getInputDataSource((IEditorInput)input);
            if (savedContainer != container) {
                DBCExecutionContext newExecutionContext = DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
                EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)new SQLNavigatorContext(container, newExecutionContext));
                this.executionContextProvider = null;
            } else {
                DBCExecutionContext iec = EditorUtils.getInputExecutionContext((IEditorInput)input);
                if (iec != null) {
                    this.executionContextProvider = () -> iec;
                }
            }
            IFile file = EditorUtils.getFileFromInput((IEditorInput)input);
            if (file != null && this.dataSourceContainer != null) {
                NavigatorResources.refreshNavigatorResource((DBPProject)this.dataSourceContainer.getProject(), (IResource)file, (Object)container);
            } else {
                IWorkbenchPage page = this.getSite().getPage();
                if (page != null) {
                    for (IEditorReference er : page.getEditorReferences()) {
                        if (er.getEditor(false) != this) continue;
                        page.hideEditor(er);
                        page.showEditor(er);
                        break;
                    }
                }
            }
        }
        this.checkConnected(false, status -> UIUtils.asyncExec(() -> {
            if (!status.isOK()) {
                DBWorkbench.getPlatformUI().showError("Can't connect to database", "Connection to '" + container.getName() + "' cannot be established.", status);
            }
        }));
        this.setPartName(this.getEditorName());
        this.fireDataSourceChange();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.acquire((DBPDataSourceTask)this);
        }
        if (SQLEditorBase.isWriteEmbeddedBinding()) {
            UIUtils.syncExec(this::embedDataSourceAssociation);
        }
        return true;
    }

    private boolean updateDataSourceContainer() {
        IWorkbenchPart activePart;
        DBPDataSourceContainer inputDataSource = null;
        if (SQLEditorBase.isReadEmbeddedBinding()) {
            inputDataSource = this.getDataSourceFromContent();
        }
        if (inputDataSource == null) {
            inputDataSource = EditorUtils.getInputDataSource((IEditorInput)this.getEditorInput());
        }
        if (inputDataSource == null && (activePart = this.getSite().getWorkbenchWindow().getActivePage().getActivePart()) != this && activePart instanceof DBPDataSourceContainerProvider) {
            DBPDataSourceContainerProvider dsp = (DBPDataSourceContainerProvider)activePart;
            inputDataSource = dsp.getDataSourceContainer();
        }
        return this.setDataSourceContainer(inputDataSource);
    }

    private void updateExecutionContext(Runnable onSuccess) {
        if (this.dataSourceContainer == null) {
            this.releaseExecutionContext();
        } else {
            DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
            if (dataSource == null) {
                this.releaseExecutionContext();
            } else if (this.curDataSource != dataSource) {
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                if (this.executionContextProvider == null) {
                    DBPDataSourceContainer container = dataSource.getContainer();
                    if (SQLEditorUtils.isOpenSeparateConnection(container)) {
                        this.initSeparateConnection(dataSource, onSuccess, true);
                    } else if (onSuccess != null) {
                        onSuccess.run();
                    }
                }
            }
        }
        UIUtils.asyncExec(() -> this.fireDataSourceChanged(null));
    }

    private void initSeparateConnection(@NotNull DBPDataSource dataSource, Runnable onSuccess, boolean readDefaultsFromInstance) {
        DBSInstance selectedInstance;
        String[] contextDefaults;
        DBSInstance dsInstance = dataSource.getDefaultInstance();
        String[] stringArray = contextDefaults = this.isRestoreActiveSchemaFromScript() ? EditorUtils.getInputContextDefaults((DBPDataSourceContainer)dataSource.getContainer(), (IEditorInput)this.getEditorInput()) : null;
        if (!ArrayUtils.isEmpty(contextDefaults) && contextDefaults[0] != null && (selectedInstance = (DBSInstance)DBUtils.findObject((Collection)dataSource.getAvailableInstances(), (String)contextDefaults[0])) != null) {
            dsInstance = selectedInstance;
        }
        OpenContextJob job = new OpenContextJob(dsInstance, onSuccess, readDefaultsFromInstance);
        job.schedule();
    }

    private void releaseExecutionContext() {
        if (this.isolatedExecutionContext != null && this.isolatedExecutionContext.isConnected()) {
            new CloseContextJob(this.isolatedExecutionContext).schedule();
        }
        this.isolatedExecutionContext = null;
        this.curDataSource = null;
    }

    private void releaseContainer() {
        this.releaseExecutionContext();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            this.dataSourceContainer.release((DBPDataSourceTask)this);
            this.dataSourceContainer = null;
        }
    }

    private DBPDataSourceContainer getDataSourceFromContent() {
        DBPProject project = this.getProject();
        IDocument document = this.getDocument();
        if (project == null || document == null || document.getNumberOfLines() == 0) {
            return null;
        }
        try {
            DBPDataSourceContainer dataSource;
            String connSpec;
            IRegion region = document.getLineInformation(0);
            String line = document.get(region.getOffset(), region.getLength());
            Matcher matcher = EMBEDDED_BINDING_PREFIX_PATTERN.matcher(line);
            if (matcher.matches() && !CommonUtils.isEmpty((String)(connSpec = matcher.group(1).trim())) && (dataSource = DataSourceUtils.getDataSourceBySpec((DBPProject)project, (String)connSpec, null, (boolean)true, (boolean)false)) != null) {
                return dataSource;
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting datasource info from script's content", e);
        }
        return null;
    }

    private void embedDataSourceAssociation() {
        if (this.getDataSourceFromContent() == this.dataSourceContainer) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            log.error((Object)"Document is null");
            return;
        }
        try {
            String line;
            Matcher matcher;
            int totalLines = document.getNumberOfLines();
            IRegion region = null;
            if (totalLines > 0 && !(matcher = EMBEDDED_BINDING_PREFIX_PATTERN.matcher(line = document.get((region = document.getLineInformation(0)).getOffset(), region.getLength()))).matches()) {
                region = null;
            }
            if (this.dataSourceContainer == null) {
                if (region == null) {
                    return;
                }
                document.replace(region.getOffset(), region.getLength(), "");
            } else {
                SQLScriptBindingType bindingType = SQLScriptBindingType.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.script.bind.commentType"));
                StringBuilder assocSpecLine = new StringBuilder(EMBEDDED_BINDING_PREFIX);
                bindingType.appendSpec(this.dataSourceContainer, assocSpecLine);
                assocSpecLine.append(GeneralUtils.getDefaultLineSeparator());
                if (region != null) {
                    document.replace(region.getOffset(), region.getLength(), assocSpecLine.toString());
                } else {
                    document.replace(0, 0, assocSpecLine.toString());
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting datasource info from script's content", e);
        }
        UIUtils.asyncExec(() -> {
            TextViewer textViewer = this.getTextViewer();
            if (textViewer != null) {
                textViewer.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SQLEditorListener listener) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SQLEditorListener listener) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public boolean isActiveTask() {
        return this.getTotalQueryRunning() > 0;
    }

    @Override
    @NotNull
    public SQLDialect getSQLDialect() {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource != null) {
            return dataSource.getSQLDialect();
        }
        if (this.dataSourceContainer == null) {
            return BasicSQLDialect.INSTANCE;
        }
        SQLDialectMetadata scriptDialect = this.dataSourceContainer.getScriptDialect();
        try {
            return scriptDialect.createInstance();
        }
        catch (DBException e) {
            log.warn((Object)String.format("Can't create sql dialect for %s:%s", scriptDialect.getId(), scriptDialect.getLabel()));
            return BasicSQLDialect.INSTANCE;
        }
    }

    public boolean isSmartAutoCommit() {
        DBPDataSource dataSource;
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (container == null && (dataSource = this.getDataSource()) != null) {
            container = dataSource.getContainer();
        }
        if (container != null) {
            DBPPreferenceStore preferenceStore = container.getPreferenceStore();
            if (preferenceStore.contains("transaction.smart.commit")) {
                return preferenceStore.getBoolean("transaction.smart.commit");
            }
            return container.getConnectionConfiguration().getConnectionType().isSmartCommit();
        }
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("transaction.smart.commit");
    }

    @Override
    public boolean isFoldingEnabled() {
        return SQLEditorUtils.isSQLSyntaxParserEnabled(this.getEditorInput()) && this.getActivePreferenceStore().getBoolean("SQLEditor.Folding.enabled");
    }

    public void setSmartAutoCommit(boolean smartAutoCommit) {
        this.getActivePreferenceStore().setValue("transaction.smart.commit", smartAutoCommit);
        try {
            this.getActivePreferenceStore().save();
        }
        catch (IOException e) {
            log.error((Object)"Error saving smart auto-commit option", (Throwable)e);
        }
    }

    public void refreshActions() {
        this.updateMultipleResultsPerTabToolItem();
        if (this.topBarMan != null) {
            this.topBarMan.getControl().redraw();
        }
        if (this.bottomBarMan != null) {
            this.bottomBarMan.getControl().redraw();
        }
        MultipleResultsPerTabMenuContribution.syncWithEditor(this);
    }

    private boolean isRestoreActiveSchemaFromScript() {
        ModelPreferences.SeparateConnectionBehavior behavior = ModelPreferences.SeparateConnectionBehavior.parse((String)this.getActivePreferenceStore().getString("database.editor.separate.connection"));
        boolean isSeparateConnection = switch (behavior) {
            case ModelPreferences.SeparateConnectionBehavior.ALWAYS -> true;
            case ModelPreferences.SeparateConnectionBehavior.NEVER -> false;
            default -> this.getDataSourceContainer() == null || !this.getDataSourceContainer().isForceUseSingleConnection();
        };
        return this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveActiveSchema") && isSeparateConnection;
    }

    public boolean isDirty() {
        ISaveablePart sp;
        Boolean state;
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            if (!queryProcessor.isDirty() && queryProcessor.getRunningJobs() <= 0) continue;
            return true;
        }
        if (QMUtils.isTransactionActive((DBCExecutionContext)this.isolatedExecutionContext)) {
            return true;
        }
        if (this.isNonPersistentEditor() && (state = ConfirmationDialog.getPersistedState((String)"save_sql_console", (int)3)) == Boolean.FALSE) {
            return false;
        }
        SQLEditorPresentation sQLEditorPresentation = this.extraPresentationManager.activePresentation;
        if (sQLEditorPresentation instanceof ISaveablePart && (sp = (ISaveablePart)sQLEditorPresentation).isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    @Nullable
    public SQLEditorPresentation getActivePresentation() {
        return this.extraPresentationManager.activePresentation;
    }

    @Nullable
    public SQLPresentationDescriptor getActivePresentationDescriptor() {
        return this.extraPresentationManager.activePresentationDescriptor;
    }

    @Nullable
    public IResultSetController getResultSetController() {
        CTabItem activeResultsTab;
        if (this.resultTabs != null && !this.resultTabs.isDisposed() && (activeResultsTab = this.getActiveResultsTab()) != null && UIUtils.isUIThread()) {
            Object tabControl = activeResultsTab.getData();
            if (tabControl instanceof QueryResultsContainer) {
                QueryResultsContainer qrc = (QueryResultsContainer)tabControl;
                return qrc.viewer;
            }
            if (tabControl instanceof SingleTabQueryProcessor) {
                SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)tabControl;
                return stqp.getFirstResults().viewer;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getAdapter(Class<T> required) {
        if (required == INavigatorModelView.class) {
            return null;
        }
        if (required == IResultSetController.class || required == ResultSetViewer.class) {
            return required.cast(this.getResultSetController());
        }
        if (this.resultTabs != null && !this.resultTabs.isDisposed()) {
            if (required == IFindReplaceTarget.class) {
                return required.cast((Object)this.findReplaceTarget);
            }
            CTabItem activeResultsTab = this.getActiveResultsTab();
            if (activeResultsTab != null && UIUtils.isUIThread()) {
                IAdaptable adaptable;
                Object adapter;
                Object tabControl = activeResultsTab.getData();
                if (tabControl instanceof QueryResultsContainer) {
                    QueryResultsContainer qrc = (QueryResultsContainer)tabControl;
                    tabControl = qrc.viewer;
                }
                if (tabControl instanceof SingleTabQueryProcessor) {
                    SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)tabControl;
                    tabControl = stqp.getFirstResults().viewer;
                }
                if (tabControl instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)tabControl).getAdapter(required)) != null) {
                    return (T)adapter;
                }
            }
        }
        return super.getAdapter(required);
    }

    public boolean checkConnected(boolean forceConnect, DBRProgressListener onFinish) {
        UIServiceConnections serviceConnections;
        boolean doConnect;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        boolean bl = doConnect = dataSourceContainer != null && (forceConnect || dataSourceContainer.getPreferenceStore().getBoolean("database.editor.connect.on.activate"));
        if (doConnect && !dataSourceContainer.isConnected() && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null) {
            UIUtils.asyncExec(() -> {
                ConnectVisualizer connectVisualizer = new ConnectVisualizer();
                serviceConnections.connectDataSource(dataSourceContainer, status -> {
                    UIUtils.asyncExec(this::reloadSyntaxRules);
                    if (onFinish != null) {
                        onFinish.onTaskFinished(status);
                    }
                    connectVisualizer.stop();
                });
            });
        }
        return dataSourceContainer != null && dataSourceContainer.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPartControl(Composite parent) {
        StyledText textWidget;
        SashForm editorContainer;
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.resultsSash = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)UIUtils.checkSashStyle((int)(this.resultSetOrientation.getSashOrientation() | 0x10000)));
        this.resultsSash.setShowBorders(true);
        CSSUtils.markConnectionTypeColor((Widget)this.resultsSash);
        this.resultsSash.setSashWidth(8);
        UIUtils.setHelp((Control)this.resultsSash, (String)"sql-editor");
        this.sqlEditorPanel = UIUtils.createPlaceholder((Composite)this.resultsSash, (int)3, (int)0);
        CSSUtils.markConnectionTypeColor((Widget)this.sqlEditorPanel);
        this.createControlsBar(this.sqlEditorPanel);
        this.sqlExtraPanelSash = new SashForm(this.sqlEditorPanel, 256);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 5;
        this.sqlExtraPanelSash.setLayoutData((Object)gd);
        StackLayout presentationStackLayout = null;
        if (!this.extraPresentationManager.presentations.isEmpty()) {
            this.presentationStack = new Composite((Composite)this.sqlExtraPanelSash, 0);
            this.presentationStack.setLayoutData((Object)new GridData(1808));
            presentationStackLayout = new StackLayout();
            this.presentationStack.setLayout((Layout)presentationStackLayout);
            editorContainer = this.presentationStack;
        } else {
            editorContainer = this.sqlExtraPanelSash;
        }
        super.createPartControl((Composite)editorContainer);
        this.getEditorControlWrapper().setLayoutData(new GridData(1808));
        this.sqlExtraPanelFolder = new CTabFolder((Composite)this.sqlExtraPanelSash, 0x8000C0);
        this.sqlExtraPanelFolder.setSelection(0);
        this.sqlExtraPanelFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            CTabItem item = this.sqlExtraPanelFolder.getSelection();
            if (item != null) {
                IActionContributor ac = (IActionContributor)item.getData("actionContributor");
                this.updateExtraViewToolbar(ac);
            }
        }));
        this.sqlExtraPanelToolbar = new ToolBarManager();
        this.sqlExtraPanelToolbar.createControl((Composite)this.sqlExtraPanelFolder);
        this.sqlExtraPanelFolder.setTopRight((Control)this.sqlExtraPanelToolbar.getControl());
        this.restoreSashRatio(this.sqlExtraPanelSash, "SQLEditor.extraPanels.ratio");
        this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
        this.addSashRatioSaveListener(this.sqlExtraPanelSash, "SQLEditor.extraPanels.ratio");
        this.createPresentationSwitchBar(this.sqlEditorPanel);
        if (presentationStackLayout != null) {
            presentationStackLayout.topControl = this.presentationStack.getChildren()[0];
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
        DBPProject project = this.getProject();
        if (project != null && project.isRegistryLoaded()) {
            this.createResultTabs();
        } else {
            UIExecutionQueue.queueExec(this::createResultTabs);
        }
        this.setAction("ShowInformation", null);
        SourceViewer viewer = this.getViewer();
        if (viewer != null && (textWidget = viewer.getTextWidget()) != null) {
            textWidget.addModifyListener(this::onTextChange);
            textWidget.addFocusListener(FocusListener.focusGainedAdapter(focusEvent -> this.refreshActions()));
        }
        this.suggestionTextPainter = new SQLSuggestionTextPainter((ITextViewer)this.getViewer());
        this.suggestionTextPainter.enable();
        textWidget = this.getViewer().getTextWidget();
        textWidget.addVerifyKeyListener(e -> {
            if ((e.keyCode == 0x1000004 || e.keyCode == 9 || e.keyCode == 13 || e.keyCode == 0x1000050) && this.suggestionTextPainter.hasContentToShow()) {
                e.doit = false;
                this.suggestionTextPainter.applyHint();
            }
        });
        textWidget.addVerifyKeyListener(e -> {
            if (e.keyCode == 27) {
                e.doit = false;
                this.suggestionTextPainter.removeHint();
            }
        });
        textWidget.addCaretListener(event -> {
            int suggestionOffset;
            int caretOffset;
            if (this.suggestionTextPainter.hasContentToShow() && (caretOffset = event.caretOffset) != (suggestionOffset = this.suggestionTextPainter.getCurrentPosition())) {
                this.suggestionTextPainter.removeHint();
            }
        });
        new ServerOutputReader().schedule();
        this.updateExecutionContext(null);
        UIExecutionQueue.queueExec(this::onDataSourceChange);
        Consumer<String> fontUpdater = s -> {
            Font font = BaseThemeSettings.instance.partTitleFont;
            if (this.resultTabs != null) {
                this.resultTabs.setFont(font);
            }
            if (this.presentationSwitchFolder != null) {
                for (VerticalButton button : this.presentationSwitchFolder.getItems()) {
                    button.setFont(font);
                }
            }
        };
        BaseThemeSettings.instance.addPropertyListener("org.eclipse.ui.workbench.TAB_TEXT_FONT", fontUpdater, (Control)parent);
        fontUpdater.accept(null);
        if (transactionStatusUpdateJob == null) {
            SQLEditor sQLEditor = this;
            synchronized (sQLEditor) {
                if (transactionStatusUpdateJob == null) {
                    transactionStatusUpdateJob = new TransactionStatusUpdateJob();
                    transactionStatusUpdateJob.schedule();
                }
            }
        }
        this.isPartControlInitialized = true;
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)textWidget, (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    protected boolean isHideQueryText() {
        return false;
    }

    protected boolean canProcessQueries() {
        if (ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.sql.execution.disabled")) {
            UIUtils.showMessageBox((Shell)this.getSite().getShell(), (String)UIMessages.dialog_policy_sql_execution_title, (String)UIMessages.dialog_policy_sql_execution_msg, (int)8);
            return false;
        }
        return true;
    }

    private void onTextChange(ModifyEvent e) {
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnChange")) {
            this.doScriptAutoSave();
        }
        if (this.suggestionTextPainter != null) {
            this.suggestionTextPainter.removeHint();
        }
    }

    private void createControlsBar(Composite sqlEditorPanel) {
        Composite leftToolPanel = new Composite(this, sqlEditorPanel, 16384){

            public void setBackground(Color color) {
                super.setBackground(color);
            }
        };
        GridLayout panelsLayout = new GridLayout(1, true);
        panelsLayout.marginHeight = 2;
        panelsLayout.marginWidth = 1;
        panelsLayout.marginTop = 1;
        panelsLayout.marginBottom = 7;
        panelsLayout.verticalSpacing = 1;
        leftToolPanel.setLayout((Layout)panelsLayout);
        leftToolPanel.setLayoutData((Object)new GridData(1040));
        ToolBar topBar = new ToolBar(leftToolPanel, 0x800200);
        topBar.setData(VIEW_PART_PROP_NAME, (Object)this);
        this.topBarMan = new ToolBarManager(topBar);
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)this.topBarMan, SIDE_TOP_TOOLBAR_CONTRIBUTION_ID);
        }
        topBar.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        CSSUtils.markConnectionTypeColor((Widget)topBar);
        this.topBarMan.update(true);
        topBar.pack();
        UIUtils.createEmptyLabel((Composite)leftToolPanel, (int)1, (int)1).setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.bottomBarMan = new ToolBarManager(0x800200);
        this.bottomBarMan.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new SQLEditorBase.ShowPreferencesAction(this), (boolean)false));
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)this.bottomBarMan, SIDE_BOTTOM_TOOLBAR_CONTRIBUTION_ID);
        }
        ToolBar bottomBar = this.bottomBarMan.createControl(leftToolPanel);
        bottomBar.setLayoutData((Object)new GridData(0x1000000, 1024, true, false));
        CSSUtils.markConnectionTypeColor((Widget)bottomBar);
        bottomBar.pack();
        this.bottomBarMan.update(true);
        this.updateMultipleResultsPerTabToolItem();
    }

    private void createPresentationSwitchBar(Composite sqlEditorPanel) {
        Set<SQLPresentationDescriptor> presentations = this.extraPresentationManager.presentations.keySet();
        if (presentations.isEmpty()) {
            return;
        }
        this.presentationSwitchFolder = new VerticalFolder(sqlEditorPanel, 131072);
        this.presentationSwitchFolder.setLayoutData((Object)new GridData(1040));
        SelectionListener switchListener = SelectionListener.widgetSelectedAdapter(e -> {
            VerticalButton button = (VerticalButton)e.item;
            SQLPresentationDescriptor newPresentation = (SQLPresentationDescriptor)((Object)((Object)button.getData()));
            SQLPresentationDescriptor curPresentation = this.getExtraPresentationDescriptor();
            if (curPresentation != null && curPresentation == newPresentation) {
                this.showExtraPresentation((SQLPresentationDescriptor)null);
            } else {
                this.showExtraPresentation(newPresentation);
            }
        });
        this.switchPresentationSQLButton = new VerticalButton(this.presentationSwitchFolder, 131104);
        this.switchPresentationSQLButton.setText(SQLEditorMessages.editors_sql_editor_presentation);
        this.switchPresentationSQLButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCRIPT));
        this.switchPresentationSQLButton.setChecked(true);
        this.switchPresentationSQLButton.addSelectionListener(switchListener);
        ArrayList<VerticalButton> buttons = new ArrayList<VerticalButton>(presentations.size());
        for (SQLPresentationDescriptor presentation : presentations) {
            VerticalButton button = this.extraPresentationManager.createPresentationButton(presentation);
            button.addSelectionListener(switchListener);
            buttons.add(button);
        }
        this.switchPresentationExtraButtons = (VerticalButton[])buttons.toArray(VerticalButton[]::new);
        UIUtils.createEmptyLabel((Composite)this.presentationSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
        this.createToggleLayoutButton();
    }

    public boolean validateEditorInputState() {
        boolean res = super.validateEditorInputState();
        if (res) {
            this.setFocusToTextControl();
        }
        return res;
    }

    @Override
    protected void updateStatusField(String category) {
        if (STATS_CATEGORY_TRANSACTION_TIMEOUT.equals(category)) {
            IStatusField field = this.getStatusField(category);
            if (field != null) {
                String status;
                try {
                    status = this.getTransactionStatusText();
                }
                catch (DBCException ignored) {
                    status = null;
                }
                if (CommonUtils.isNotEmpty((String)status)) {
                    field.setText(status);
                    field.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_WARNING));
                } else {
                    field.setText(null);
                    field.setImage(null);
                }
            }
            return;
        }
        super.updateStatusField(category);
    }

    private void updateMultipleResultsPerTabToolItem() {
        ToolItem toolItem = this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab");
        if (toolItem != null) {
            boolean multipleResultsPerTab = this.isMultipleResultsPerTabEnabled();
            toolItem.setImage(multipleResultsPerTab ? MultipleResultsPerTabMenuContribution.FALSE_IMAGE : MultipleResultsPerTabMenuContribution.TRUE_IMAGE);
            toolItem.setSelection(multipleResultsPerTab);
        }
    }

    private boolean useTabPerQuery(boolean singleQuery) {
        return singleQuery || !this.isMultipleResultsPerTabEnabled();
    }

    public boolean isMultipleResultsPerTabEnabled() {
        return CommonUtils.toBoolean((Object)SQLEditor.multipleResultsPerTabProperty.getPropertyValue((EditorPart)this).value, (boolean)false);
    }

    public void toggleMultipleResultsPerTab() {
        boolean wasEnabled = this.isMultipleResultsPerTabEnabled();
        multipleResultsPerTabProperty.setPropertyValue((EditorPart)this, Boolean.toString(!wasEnabled));
    }

    private void createResultTabs() {
        this.resultTabs = new CTabFolder((Composite)this.resultsSash, 0x800080){

            public void setBackground(Color color) {
                if (SQLEditor.this.resultTabs != null && !SQLEditor.this.resultTabs.isDisposed()) {
                    UIUtils.asyncExec(() -> CSSUtils.markConnectionTypeColor((Widget)SQLEditor.this.resultTabs));
                } else {
                    super.setBackground(color);
                }
            }
        };
        CSSUtils.markConnectionTypeColor((Widget)this.resultTabs);
        this.resultTabsReorder = new TabFolderReorder(this.resultTabs);
        this.resultTabs.setLayoutData((Object)new GridData(1808));
        this.resultTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplainPlanViewer epv;
                SQLQuery planQuery;
                Object data;
                if (SQLEditor.this.extraPresentationManager.activePresentationPanel != null) {
                    SQLEditor.this.extraPresentationManager.activePresentationPanel.deactivatePanel();
                    SQLEditor.this.extraPresentationManager.activePresentationPanel = null;
                }
                if ((data = e.item.getData()) instanceof QueryResultsContainer) {
                    QueryResultsContainer qrc = (QueryResultsContainer)data;
                    SQLEditor.this.setActiveResultsContainer(qrc);
                } else if (data instanceof SingleTabQueryProcessor) {
                    SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)data;
                    SQLEditor.this.setActiveResultsContainer(stqp.getFirstResults());
                } else if (data instanceof SQLEditorPresentationPanel) {
                    SQLEditorPresentationPanel pp;
                    SQLEditor.this.extraPresentationManager.activePresentationPanel = pp = (SQLEditorPresentationPanel)data;
                    SQLEditor.this.extraPresentationManager.activePresentationPanel.activatePanel();
                } else if (data instanceof ExplainPlanViewer && (planQuery = (epv = (ExplainPlanViewer)((Object)data)).getQuery()) != null) {
                    SQLEditor.this.getSelectionProvider().setSelection((ISelection)new TextSelection(planQuery.getOffset(), 0));
                }
            }
        });
        this.addSashRatioSaveListener((SashForm)this.resultsSash, "SQLEditor.resultSet.ratio");
        this.resultTabs.addListener(1001, event -> {
            Object patt1$temp;
            CTabItem item = (CTabItem)event.item;
            Object patt0$temp = item.getData();
            if (patt0$temp instanceof MultiTabsQueryResultsContainer) {
                MultiTabsQueryResultsContainer qrc = (MultiTabsQueryResultsContainer)patt0$temp;
                qrc.setResultsTab(item);
            }
            if ((patt1$temp = item.getData()) instanceof SingleTabQueryProcessor) {
                SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)patt1$temp;
                stqp.setResultsTab(item);
            }
        });
        this.restoreSashRatio((SashForm)this.resultsSash, "SQLEditor.resultSet.ratio");
        TextViewer textViewer = this.getTextViewer();
        if (textViewer != null) {
            textViewer.getTextWidget().addTraverseListener(e -> {
                ResultSetViewer viewer;
                if (e.detail == 16 && e.stateMask == SWT.MOD1 && (viewer = this.getActiveResultSetViewer()) != null && viewer.getActivePresentation().getControl().isVisible()) {
                    viewer.getActivePresentation().getControl().setFocus();
                    e.detail = 0;
                }
            });
        }
        this.resultTabs.setSimple(true);
        this.resultTabs.setFont(JFaceResources.getFont((String)"org.eclipse.ui.workbench.TAB_TEXT_FONT"));
        this.resultTabs.addMouseListener(MouseListener.mouseUpAdapter(e -> {
            CTabItem item;
            if (e.button == 2 && (item = this.resultTabs.getItem(new Point(e.x, e.y))) != null && item.getShowClose()) {
                item.dispose();
            }
        }));
        this.resultTabs.addListener(8, event -> {
            if (event.button != 1) {
                return;
            }
            CTabItem selectedItem = this.resultTabs.getItem(new Point(event.getBounds().x, event.getBounds().y));
            if (selectedItem != null && selectedItem == this.resultTabs.getSelection()) {
                this.toggleEditorMaximize();
            }
        });
        this.createExtraViewControls();
        if (this.isHideQueryText()) {
            this.resultsSash.setMaximizedControl((Control)this.resultTabs);
        } else {
            this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
        }
        this.resultTabs.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            this.activeResultsTab = this.resultTabs.getItem(new Point(e.x, e.y));
        }));
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.resultTabs);
        menuMgr.addMenuListener(manager -> {
            boolean activeTabHasMultipleResults;
            final CTabItem activeTab = this.getActiveResultsTab();
            final boolean activeTabHasSingleResult = activeTab != null && activeTab.getData() instanceof QueryResultsContainer;
            boolean bl = activeTabHasMultipleResults = activeTab != null && activeTab.getData() instanceof SingleTabQueryProcessor;
            if (activeTabHasSingleResult || activeTabHasMultipleResults) {
                QueryResultsContainer container;
                int pinnedTabsCount = 0;
                int resultTabsCount = 0;
                for (CTabItem item : this.resultTabs.getItems()) {
                    if (!(item.getData() instanceof QueryProcessingComponent)) continue;
                    ++resultTabsCount;
                    if (!(item.getData() instanceof QueryResultsContainer) || !((QueryResultsContainer)item.getData()).isPinned()) continue;
                    ++pinnedTabsCount;
                }
                if (activeTab.getShowClose()) {
                    manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.close.tab"));
                    if (resultTabsCount - pinnedTabsCount > 1) {
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_all_tabs){

                            public void run() {
                                SQLEditor.this.closeExtraResultTabs(null, false, false);
                            }
                        });
                        if (activeTabHasSingleResult) {
                            manager.add((IAction)new Action(this, SQLEditorMessages.action_result_tabs_close_query_tabs){

                                public void run() {
                                    QueryProcessor processor = ((QueryResultsContainer)activeTab.getData()).queryProcessor;
                                    ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                    for (QueryResultsContainer container : processor.getResultContainers()) {
                                        if (container.isPinned() || container.queryProcessor != processor) continue;
                                        tabs.add(container.getResultsTab());
                                    }
                                    for (CTabItem tab : tabs) {
                                        tab.dispose();
                                    }
                                }
                            });
                        }
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_other_tabs){

                            public void run() {
                                ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                for (CTabItem tab : SQLEditor.this.resultTabs.getItems()) {
                                    if (!tab.getShowClose() || tab == activeTab || SQLEditor.this.isPinned(tab)) continue;
                                    tabs.add(tab);
                                }
                                for (CTabItem tab : tabs) {
                                    tab.dispose();
                                }
                                if (activeTabHasSingleResult) {
                                    SQLEditor.this.setActiveResultsContainer((QueryResultsContainer)activeTab.getData());
                                }
                                if (activeTabHasMultipleResults) {
                                    SQLEditor.this.setActiveResultsContainer(((SingleTabQueryProcessor)activeTab.getData()).getFirstResults());
                                }
                            }
                        });
                        if (this.resultTabs.indexOf(activeTab) - pinnedTabsCount > 0) {
                            manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_tabs_to_the_left){

                                public void run() {
                                    ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                    int last = SQLEditor.this.resultTabs.indexOf(activeTab);
                                    for (int i = 0; i < last; ++i) {
                                        CTabItem tab = SQLEditor.this.resultTabs.getItem(i);
                                        if (SQLEditor.this.isPinned(tab)) continue;
                                        tabs.add(tab);
                                    }
                                    for (CTabItem tab : tabs) {
                                        tab.dispose();
                                    }
                                }
                            });
                        }
                        if (this.resultTabs.indexOf(activeTab) < resultTabsCount - pinnedTabsCount - 1) {
                            manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_tabs_to_the_right){

                                public void run() {
                                    ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                    for (int i = SQLEditor.this.resultTabs.indexOf(activeTab) + 1; i < SQLEditor.this.resultTabs.getItemCount(); ++i) {
                                        CTabItem tab = SQLEditor.this.resultTabs.getItem(i);
                                        if (SQLEditor.this.isPinned(tab)) continue;
                                        tabs.add(tab);
                                    }
                                    for (CTabItem tab : tabs) {
                                        tab.dispose();
                                    }
                                }
                            });
                        }
                    }
                }
                QueryResultsContainer queryResultsContainer = container = activeTabHasSingleResult ? (QueryResultsContainer)activeTab.getData() : null;
                if (container != null && container.hasData()) {
                    boolean isPinned = container.isPinned();
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggle.pinned.tab"));
                    if (isPinned && pinnedTabsCount > 1) {
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_unpin_all_tabs){

                            public void run() {
                                for (CTabItem item : SQLEditor.this.resultTabs.getItems()) {
                                    if (!(item.getData() instanceof QueryResultsContainer) || !((QueryResultsContainer)item.getData()).isPinned()) continue;
                                    ((QueryResultsContainer)item.getData()).setPinned(false);
                                }
                            }
                        });
                    }
                    manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_set_name){

                        public void run() {
                            EnterNameDialog dialog = new EnterNameDialog(SQLEditor.this.resultTabs.getShell(), SQLEditorMessages.action_result_tabs_set_name_title, activeTab.getText());
                            if (dialog.open() == 0) {
                                container.setTabName(dialog.getResult());
                            }
                        }
                    });
                    if (!container.isStatistics()) {
                        manager.add((IAction)new Action(this, SQLEditorMessages.action_result_tabs_detach_tab){

                            public void run() {
                                container.detach();
                            }
                        });
                    }
                    if (container.getQuery() != null) {
                        manager.add((IContributionItem)new Separator());
                        AssignVariableAction action = new AssignVariableAction(this, container.getQuery().getText());
                        action.setEditable(false);
                        manager.add((IAction)action);
                    }
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.maximize.result.panel"));
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.resultTabs.setMenu(menu);
    }

    private void addSashRatioSaveListener(SashForm sash, String prefId) {
        Control control = sash.getChildren()[0];
        control.addListener(11, event -> {
            if (!control.isDisposed()) {
                int[] weights = sash.getWeights();
                IPreferenceStore prefs = this.getPreferenceStore();
                if (prefs != null && weights.length == 2) {
                    prefs.setValue(prefId, weights[0] + "-" + weights[1]);
                }
            }
        });
    }

    private void restoreSashRatio(SashForm sash, String prefId) {
        String[] weightsStr;
        String resultsPanelRatio = this.getPreferenceStore().getString(prefId);
        if (!CommonUtils.isEmpty((String)resultsPanelRatio) && (weightsStr = resultsPanelRatio.split("-")).length > 1) {
            int[] weights = new int[]{CommonUtils.toInt((Object)weightsStr[0]), CommonUtils.toInt((Object)weightsStr[1])};
            if (weights[1] < weights[0] / 15 || weights[0] < weights[1] / 15) {
                log.debug((Object)"Restore default sash weights");
            } else {
                sash.setWeights(weights);
            }
        }
    }

    void setActiveResultsContainer(QueryResultsContainer data) {
        this.curResultsContainer = data;
        this.curQueryProcessor = this.curResultsContainer.queryProcessor;
    }

    private boolean isPinned(CTabItem tabItem) {
        if (tabItem.getData() instanceof QueryResultsContainer) {
            return ((QueryResultsContainer)tabItem.getData()).isPinned();
        }
        return false;
    }

    public void toggleExtraPanelsLayout() {
        CTabItem outTab = this.getExtraViewTab((Control)this.outputViewer);
        CTabItem logTab = this.getExtraViewTab((Control)this.logViewer);
        CTabItem varTab = this.getExtraViewTab((Control)this.variablesViewer);
        if (outTab != null) {
            outTab.dispose();
        }
        if (logTab != null) {
            logTab.dispose();
        }
        if (varTab != null) {
            varTab.dispose();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String epLocation = this.getExtraPanelsLocation();
        epLocation = "results".equals(epLocation) ? "right" : "results";
        preferenceStore.setValue("SQLEditor.extraPanels.location", epLocation);
        this.createExtraViewControls();
        if (outTab != null) {
            this.showOutputPanel(true);
        }
        if (logTab != null) {
            this.showExecutionLogPanel(true);
        }
        if (varTab != null) {
            this.showVariablesPanel(true);
        }
    }

    public String getExtraPanelsLocation() {
        return this.getPreferenceStore().getString("SQLEditor.extraPanels.location");
    }

    private void createExtraViewControls() {
        if (this.logViewer != null) {
            this.logViewer.dispose();
            this.logViewer = null;
        }
        if (this.variablesViewer != null) {
            this.variablesViewer.dispose();
            this.variablesViewer = null;
        }
        if (this.outputViewer != null) {
            this.outputViewer.dispose();
            this.outputViewer = null;
        }
        if (this.sqlExtraPanelFolder != null) {
            for (CTabItem ti : this.sqlExtraPanelFolder.getItems()) {
                ti.dispose();
            }
        }
        CTabFolder folder = this.getFolderForExtraPanels();
        this.logViewer = new SQLLogPanel((Composite)folder, this);
        this.variablesViewer = new SQLVariablesPanel((Composite)folder, this);
        this.outputViewer = new SQLEditorOutputViewer(this.getSite(), (Composite)folder, 16384);
        this.outputViewer.setExecutionContext(this.isolatedExecutionContext);
        if (this.getFolderForExtraPanels() != this.sqlExtraPanelFolder) {
            this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
        }
    }

    public CTabFolder getResultTabsContainer() {
        return this.resultTabs;
    }

    private CTabFolder getFolderForExtraPanels() {
        CTabFolder folder = this.sqlExtraPanelFolder;
        String epLocation = this.getExtraPanelsLocation();
        if ("results".equals(epLocation)) {
            folder = this.resultTabs;
        }
        return folder;
    }

    private CTabItem getExtraViewTab(Control control) {
        CTabFolder tabFolder = this.getFolderForExtraPanels();
        for (CTabItem item : tabFolder.getItems()) {
            if (item.getData() != control) continue;
            return item;
        }
        return null;
    }

    private void showExtraView(@NotNull String commandId, @NotNull String name, @NotNull String toolTip, @NotNull Image image, @NotNull Control view, @Nullable IActionContributor actionContributor, @Nullable Boolean show) {
        boolean isTabsToTheRight;
        ToolItem viewItem = this.getViewToolItem(commandId);
        if (viewItem == null) {
            log.warn((Object)("Tool item for command " + commandId + " not found"));
            return;
        }
        CTabFolder tabFolder = this.getFolderForExtraPanels();
        CTabItem curItem = this.getExtraViewTab(view);
        if (curItem != null) {
            if (show == null || !show.booleanValue()) {
                viewItem.setSelection(false);
                curItem.dispose();
            }
            return;
        }
        if (show != null && !show.booleanValue()) {
            return;
        }
        boolean bl = isTabsToTheRight = tabFolder == this.sqlExtraPanelFolder;
        if (isTabsToTheRight) {
            if (this.sqlExtraPanelSash.getMaximizedControl() != null) {
                this.sqlExtraPanelSash.setMaximizedControl(null);
            }
        } else {
            this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
            this.showResultsPanel(true);
        }
        if (view == this.outputViewer) {
            this.updateOutputViewerIcon(false);
            this.outputViewer.resetNewOutput();
        }
        viewItem.setSelection(true);
        CTabItem item = new CTabItem(tabFolder, 64);
        item.setControl(view);
        item.setText(name);
        item.setToolTipText(toolTip);
        item.setImage(image);
        item.setData((Object)view);
        item.setData("actionContributor", (Object)actionContributor);
        item.addDisposeListener(e -> {
            if (!viewItem.isDisposed()) {
                viewItem.setSelection(false);
            }
            if (tabFolder.getItemCount() == 0) {
                this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
            }
        });
        tabFolder.setSelection(item);
        if (isTabsToTheRight) {
            this.updateExtraViewToolbar(actionContributor);
        }
    }

    private void updateExtraViewToolbar(IActionContributor actionContributor) {
        this.sqlExtraPanelToolbar.removeAll();
        if (actionContributor != null) {
            actionContributor.contributeActions((IContributionManager)this.sqlExtraPanelToolbar);
        }
        this.sqlExtraPanelToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggle.extraPanels", (int)32, (DBPImage)UIIcon.ARROW_DOWN));
        this.sqlExtraPanelToolbar.update(true);
    }

    @Nullable
    private ToolItem getViewToolItem(@NotNull String commandId) {
        ToolItem viewItem;
        ToolItem toolItem = viewItem = this.topBarMan == null ? null : UIUtils.findToolItemByCommandId((ToolBarManager)this.topBarMan, (String)commandId);
        if (viewItem == null) {
            viewItem = this.bottomBarMan == null ? null : UIUtils.findToolItemByCommandId((ToolBarManager)this.bottomBarMan, (String)commandId);
        }
        return viewItem;
    }

    private CTabItem getActiveResultsTab() {
        return this.activeResultsTab == null || this.activeResultsTab.isDisposed() ? (this.resultTabs == null ? null : this.resultTabs.getSelection()) : this.activeResultsTab;
    }

    public void closeActiveTab() {
        CTabItem tabItem = this.getActiveResultsTab();
        if (tabItem != null && tabItem.getShowClose()) {
            tabItem.dispose();
            this.activeResultsTab = null;
        }
    }

    public void toggleActiveTabPinned() {
        CTabItem activeTab = this.getActiveResultsTab();
        QueryResultsContainer container = (QueryResultsContainer)activeTab.getData();
        if (!container.hasData()) {
            return;
        }
        boolean isPinned = container.isPinned();
        container.setPinned(!isPinned);
        CTabItem currTabItem = activeTab;
        if (isPinned) {
            CTabItem nextTabItem;
            for (int i = this.resultTabs.indexOf(activeTab) + 1; i < this.resultTabs.getItemCount() && !(nextTabItem = this.resultTabs.getItem(i)).getShowClose(); ++i) {
                this.resultTabsReorder.swapTabs(currTabItem, nextTabItem);
                currTabItem = nextTabItem;
            }
        } else {
            CTabItem nextTabItem;
            for (int i = this.resultTabs.indexOf(activeTab) - 1; i >= 0 && (nextTabItem = this.resultTabs.getItem(i)).getShowClose(); --i) {
                this.resultTabsReorder.swapTabs(currTabItem, nextTabItem);
                currTabItem = nextTabItem;
            }
        }
    }

    public boolean isActiveTabPinned() {
        CTabItem tabItem = this.getActiveResultsTab();
        return tabItem != null && ((QueryResultsContainer)tabItem.getData()).isPinned();
    }

    public void showOutputPanel(@Nullable Boolean show) {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.output", SQLEditorMessages.editors_sql_output, SQLEditorMessages.editors_sql_output_tip, IMG_OUTPUT, (Control)this.outputViewer, manager -> manager.add((IAction)new OutputAutoShowToggleAction()), show);
    }

    public void showExecutionLogPanel(@Nullable Boolean show) {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.log", SQLEditorMessages.editors_sql_execution_log, SQLEditorMessages.editors_sql_execution_log_tip, IMG_LOG, (Control)this.logViewer, null, show);
    }

    public void showVariablesPanel(@Nullable Boolean show) {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.variables", SQLEditorMessages.editors_sql_variables, SQLEditorMessages.editors_sql_variables_tip, IMG_VARIABLES, (Control)this.variablesViewer, null, show);
        UIUtils.asyncExec(() -> this.variablesViewer.refreshVariables());
    }

    public <T> T getExtraPresentationPanel(Class<T> panelClass) {
        for (CTabItem tabItem : this.resultTabs.getItems()) {
            if (!(tabItem.getData() instanceof SQLEditorPresentationPanel) || tabItem.getData().getClass() != panelClass) continue;
            return panelClass.cast(tabItem.getData());
        }
        return null;
    }

    public boolean showPresentationPanel(SQLEditorPresentationPanel panel) {
        for (CTabItem item : this.resultTabs.getItems()) {
            if (item.getData() != panel) continue;
            this.setResultTabSelection(item);
            return true;
        }
        return false;
    }

    private void setResultTabSelection(CTabItem item) {
        if (item != null && (this.isResultSetAutoFocusEnabled || !(item.getData() instanceof QueryProcessingComponent) || this.resultTabs.getItemCount() == 1)) {
            this.resultTabs.setSelection(item);
        }
    }

    public SQLEditorPresentationPanel showPresentationPanel(String panelID) {
        IAction action;
        for (IContributionItem contributionItem : this.topBarMan.getItems()) {
            if (!(contributionItem instanceof ActionContributionItem) || !((action = ((ActionContributionItem)contributionItem).getAction()) instanceof PresentationPanelToggleAction) || !((PresentationPanelToggleAction)action).panel.getId().equals(panelID)) continue;
            action.run();
            return this.extraPresentationManager.activePresentationPanel;
        }
        for (IContributionItem contributionItem : this.bottomBarMan.getItems()) {
            if (!(contributionItem instanceof ActionContributionItem) || !((action = ((ActionContributionItem)contributionItem).getAction()) instanceof PresentationPanelToggleAction) || !((PresentationPanelToggleAction)action).panel.getId().equals(panelID)) continue;
            action.run();
            return this.extraPresentationManager.activePresentationPanel;
        }
        return null;
    }

    public boolean hasMaximizedControl() {
        return this.resultsSash.getMaximizedControl() != null;
    }

    @Nullable
    public SQLPresentationDescriptor getExtraPresentationDescriptor() {
        return this.extraPresentationManager.activePresentationDescriptor;
    }

    public void showExtraPresentation(@NotNull String presentationId) {
        SQLPresentationDescriptor presentation = SQLPresentationRegistry.getInstance().getPresentation(presentationId);
        if (presentation != null) {
            this.showExtraPresentation(presentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showExtraPresentation(@Nullable SQLPresentationDescriptor presentation) {
        if (this.extraPresentationManager.activePresentationDescriptor == presentation || this.presentationStack == null) {
            return;
        }
        if (presentation != null && !presentation.isEnabled((IWorkbenchSite)this.getSite())) {
            return;
        }
        StackLayout stackLayout = (StackLayout)this.presentationStack.getLayout();
        try {
            if (!this.extraPresentationManager.setActivePresentation(presentation)) {
                return;
            }
        }
        catch (DBException e) {
            log.error((Object)"Error creating presentation", (Throwable)e);
        }
        this.resultsSash.setRedraw(false);
        try {
            if (this.extraPresentationManager.activePresentation == null) {
                stackLayout.topControl = this.presentationStack.getChildren()[0];
                this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
            } else {
                stackLayout.topControl = this.extraPresentationManager.getActivePresentationControl();
                this.getSite().setSelectionProvider(this.extraPresentationManager.activePresentation.getSelectionProvider());
            }
            boolean sideBarChanged = false;
            for (Control control : this.presentationSwitchFolder.getChildren()) {
                if (!(control.getData() instanceof SQLPresentationPanelDescriptor)) continue;
                control.dispose();
                sideBarChanged = true;
            }
            for (Control control : this.resultTabs.getItems()) {
                if (!(control.getData() instanceof SQLEditorPresentationPanel)) continue;
                control.dispose();
            }
            this.extraPresentationManager.activePresentationPanel = null;
            if (this.extraPresentationManager.activePresentation != null) {
                List<SQLPresentationPanelDescriptor> panels = this.extraPresentationManager.activePresentationDescriptor.getPanels();
                for (SQLPresentationPanelDescriptor panelDescriptor : panels) {
                    this.removeToggleLayoutButton();
                    sideBarChanged = true;
                    PresentationPanelToggleAction presentationPanelToggleAction = new PresentationPanelToggleAction(panelDescriptor);
                    VerticalButton panelButton = new VerticalButton(this.presentationSwitchFolder, 131072);
                    panelButton.setLayoutData((Object)new GridData(8));
                    panelButton.setAction((IAction)presentationPanelToggleAction, true);
                    panelButton.setData((Object)panelDescriptor);
                    if (panelDescriptor.isAutoActivate()) {
                        presentationPanelToggleAction.run();
                    }
                    this.createToggleLayoutButton();
                }
            }
            this.switchPresentationSQLButton.setChecked(presentation == null);
            for (Control control : this.switchPresentationExtraButtons) {
                control.setChecked(presentation != null && control.getData() == presentation);
            }
            this.presentationSwitchFolder.layout(true);
            this.presentationSwitchFolder.redraw();
            if (sideBarChanged) {
                this.topBarMan.update(true);
                this.bottomBarMan.update(true);
                this.topBarMan.getControl().getParent().layout(true);
                this.bottomBarMan.getControl().getParent().layout(true);
            }
            this.presentationStack.layout(true, true);
            UIUtils.asyncExec(() -> {
                if (this.extraPresentationManager.activePresentation == null) {
                    this.setFocusToTextControl();
                } else {
                    this.extraPresentationManager.getActivePresentationControl().setFocus();
                }
            });
        }
        finally {
            this.resultsSash.setRedraw(true);
        }
    }

    private void createToggleLayoutButton() {
        VerticalButton.create((VerticalFolder)this.presentationSwitchFolder, (int)131104, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggleLayout", (boolean)false);
    }

    private void removeToggleLayoutButton() {
        for (VerticalButton vButton : this.presentationSwitchFolder.getItems()) {
            if (vButton.getCommandId() == null || !vButton.getCommandId().equals("org.jkiss.dbeaver.ui.editors.sql.toggleLayout")) continue;
            vButton.dispose();
        }
    }

    public void toggleResultPanel(boolean switchFocus, boolean createQueryProcessor) {
        if (this.isHideQueryText()) {
            return;
        }
        UIUtils.syncExec(() -> {
            if (this.resultsSash.getMaximizedControl() == null) {
                this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
                this.switchFocus(false);
            } else {
                if (this.resultTabs.getItemCount() == 0 && createQueryProcessor) {
                    this.createQueryProcessor(true, true, true);
                }
                this.resultsSash.setMaximizedControl(null);
                if (switchFocus) {
                    this.switchFocus(true);
                }
            }
        });
    }

    public void toggleEditorMaximize() {
        this.setEditorMaximized(!this.resultsSash.isUpHidden());
    }

    public void setEditorMaximized(boolean maximized) {
        if (this.isHideQueryText()) {
            return;
        }
        if (maximized) {
            this.resultsSash.hideUp();
            this.switchFocus(true);
        } else {
            this.resultsSash.showUp();
            this.switchFocus(false);
        }
    }

    private void switchFocus(boolean results) {
        if (results) {
            ResultSetViewer activeRS = this.getActiveResultSetViewer();
            if (activeRS != null && activeRS.getActivePresentation() != null) {
                activeRS.getActivePresentation().getControl().setFocus();
            } else {
                CTabItem activeTab = this.resultTabs.getSelection();
                if (activeTab != null && activeTab.getControl() != null) {
                    activeTab.getControl().setFocus();
                }
            }
        } else {
            this.getEditorControlWrapper().setFocus();
        }
    }

    public void toggleActivePanel() {
        if (this.resultsSash.getMaximizedControl() == null) {
            this.switchFocus(!UIUtils.hasFocus((Control)this.resultTabs));
        }
    }

    private void updateResultSetOrientation() {
        try {
            this.resultSetOrientation = ResultSetOrientation.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.resultSet.orientation"));
        }
        catch (IllegalArgumentException e) {
            this.resultSetOrientation = ResultSetOrientation.HORIZONTAL;
        }
        if (this.resultsSash != null) {
            this.resultsSash.setOrientation(this.resultSetOrientation.getSashOrientation());
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.updateResultSetOrientation();
        SQLScriptContext parentContext = null;
        DatabaseEditorContext parentEditorContext = EditorUtils.getEditorContext((IEditorInput)editorInput);
        if (parentEditorContext instanceof SQLNavigatorContext) {
            SQLNavigatorContext nc = (SQLNavigatorContext)parentEditorContext;
            parentContext = nc.getScriptContext();
            if (nc.isReuseExecutionContext()) {
                DBCExecutionContext iec = nc.getExecutionContext();
                this.executionContextProvider = () -> iec;
            }
        }
        this.globalScriptContext = new SQLScriptContext(parentContext, this, null, new OutputLogWriter(), (SQLParametersProvider)new SQLEditorParametersProvider((IWorkbenchPartSite)site)){

            public Path getSourceFile() {
                return EditorUtils.getPathFromInput((Object)SQLEditor.this.getEditorInput());
            }
        };
        DBCExecutionContext inputExecutionContext = this.globalScriptContext.getExecutionContext();
        if (inputExecutionContext != null) {
            this.dataSourceContainer = inputExecutionContext.getDataSource().getContainer();
        }
        this.globalScriptContext.addListener(new DBCScriptContextListener(){

            public void variableChanged(DBCScriptContextListener.ContextAction action, DBCScriptContext.VariableInfo variable) {
                this.saveContextVariables();
            }

            public void parameterChanged(DBCScriptContextListener.ContextAction action, String name, Object value) {
                this.saveContextVariables();
            }

            private void saveContextVariables() {
                new AbstractJob("Save variables"){

                    @NotNull
                    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                        DBPDataSourceContainer ds = SQLEditor.this.getDataSourceContainer();
                        if (ds != null) {
                            SQLEditor.this.globalScriptContext.saveVariables(ds.getDriver(), null);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule(200L);
            }
        });
        for (SQLEditorAddInDescriptor addInDesc : SQLEditorAddInsRegistry.getInstance().getAddIns()) {
            try {
                SQLEditorAddIn addIn = addInDesc.createInstance();
                addIn.init(this);
                this.addIns.add(addIn);
            }
            catch (Throwable ex) {
                log.error((Object)"Error during SQL editor add-in initialization", ex);
            }
        }
        this.extraPresentationManager = new ExtraPresentationManager(this);
    }

    @Nullable
    public <T extends SQLEditorAddIn> T findAddIn(@NotNull Class<T> addInClass) {
        for (SQLEditorAddIn addIn : this.addIns) {
            if (!addInClass.isInstance(addIn)) continue;
            SQLEditorAddIn concreteAddIn = addIn;
            return (T)concreteAddIn;
        }
        return null;
    }

    @Override
    protected void doSetInput(IEditorInput editorInput) throws CoreException {
        this.checkInputFileExistence(editorInput);
        try {
            super.doSetInput(editorInput);
        }
        catch (Throwable e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)out, true));
            editorInput = new StringEditorInput("Error", (CharSequence)CommonUtils.truncateString((String)out.toString(), (int)10000), true, GeneralUtils.UTF8_ENCODING);
            try {
                super.doSetInput(editorInput);
            }
            catch (Throwable ex) {
                throw e;
            }
            log.error((Object)"Error loading input SQL file", e);
        }
        this.syntaxLoaded = false;
        final IEditorInput finalEditorInput = editorInput;
        Runnable inputinitializer = new Runnable(){

            @Override
            public void run() {
                if (SQLEditor.this.isPartControlInitialized || finalEditorInput instanceof IncludedScriptFileEditorInput) {
                    SQLEditor.this.accomplishEditorInputInitialization(finalEditorInput);
                } else {
                    UIExecutionQueue.queueExec((Runnable)this);
                }
            }
        };
        if (editorInput instanceof IncludedScriptFileEditorInput) {
            inputinitializer.run();
        } else {
            UIExecutionQueue.queueExec((Runnable)inputinitializer);
        }
        this.setPartName(this.getEditorName());
        if (this.isNonPersistentEditor() && this.isDetectTitleImageFromInput()) {
            this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_CONSOLE));
        }
        this.editorImage = this.baseEditorImage = this.getTitleImage();
    }

    private void accomplishEditorInputInitialization(@NotNull IEditorInput editorInput) {
        DBPDataSourceContainer newDataSource;
        DBPDataSourceContainer oldDataSource = this.getDataSourceContainer();
        if (oldDataSource != (newDataSource = EditorUtils.getInputDataSource((IEditorInput)this.getEditorInput()))) {
            this.dataSourceContainer = null;
            this.updateDataSourceContainer();
        } else {
            this.reloadSyntaxRules();
        }
        DBPDataSourceContainer dataSource = EditorUtils.getInputDataSource((IEditorInput)editorInput);
        SQLEditorFeatures.SQL_EDITOR_OPEN.use(Map.of("driver", dataSource == null ? "" : dataSource.getDriver().getPreconfiguredId()));
        DataSourceToolbarUtils.refreshSelectorToolbar((IWorkbenchWindow)this.getSite().getWorkbenchWindow());
    }

    private void checkInputFileExistence(IEditorInput editorInput) {
        try {
            if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                if (!file.exists()) {
                    file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error checking SQL file", (Throwable)e);
        }
    }

    protected boolean isDetectTitleImageFromInput() {
        return true;
    }

    public String getTitleToolTip() {
        String scriptPath;
        IEditorInput editorInput;
        if (!DBWorkbench.getPlatform().getApplication().isStandalone()) {
            return this.getTitle();
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer == null) {
            return super.getTitleToolTip();
        }
        IEditorInput iEditorInput = editorInput = this.getEditorInput();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IFileEditorInput.class, IPathEditorInput.class, IURIEditorInput.class, INonPersistentEditorInput.class}, (Object)iEditorInput, n)) {
            case 0: {
                IFileEditorInput fei = (IFileEditorInput)iEditorInput;
                scriptPath = fei.getFile().getFullPath().toString();
                break;
            }
            case 1: {
                IPathEditorInput pei = (IPathEditorInput)iEditorInput;
                scriptPath = pei.getPath().toString();
                break;
            }
            case 2: {
                IURIEditorInput iei = (IURIEditorInput)iEditorInput;
                URI uri = iei.getURI();
                if ("file".equals(uri.getScheme())) {
                    scriptPath = new File(uri).getAbsolutePath();
                    break;
                }
                scriptPath = uri.toString();
                break;
            }
            case 3: {
                INonPersistentEditorInput npi = (INonPersistentEditorInput)iEditorInput;
                scriptPath = "SQL Console";
                break;
            }
            default: {
                scriptPath = editorInput.getName();
                if (!CommonUtils.isEmpty((String)scriptPath)) break;
                scriptPath = "<not a file>";
            }
        }
        StringBuilder tip = new StringBuilder();
        tip.append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_path, (Object)scriptPath)).append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_connection, (Object)dataSourceContainer.getName())).append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_type, (Object)dataSourceContainer.getDriver().getFullName())).append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_url, (Object)dataSourceContainer.getConnectionConfiguration().getUrl()));
        SQLEditorVariablesResolver scriptNameResolver = new SQLEditorVariablesResolver(dataSourceContainer, dataSourceContainer.getConnectionConfiguration(), this.getExecutionContext(), scriptPath, null, this.getProject());
        if (scriptNameResolver.get("database") != null) {
            tip.append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_database, (Object)scriptNameResolver.get("database")));
        }
        if (scriptNameResolver.get("schema") != null) {
            tip.append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_schema, (Object)scriptNameResolver.get("schema")));
        }
        EditorUtils.appendProjectToolTip((StringBuilder)tip, (DBPProject)this.getProject());
        if (dataSourceContainer.getConnectionError() != null) {
            tip.append("\n\nConnection error:\n").append(dataSourceContainer.getConnectionError());
        }
        return tip.toString();
    }

    protected String getEditorName() {
        File localFile;
        IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        String scriptName = file != null ? file.getFullPath().removeFileExtension().lastSegment() : ((localFile = EditorUtils.getLocalFileFromInput((Object)this.getEditorInput())) != null ? localFile.getName() : this.getEditorInput().getName());
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        String pattern = preferenceStore.getString("script.title.pattern");
        return GeneralUtils.replaceVariables((String)pattern, (IVariableResolver)new SQLEditorVariablesResolver(this.dataSourceContainer, null, this.getExecutionContext(), scriptName, file, this.getProject()));
    }

    public void setFocus() {
        super.setFocus();
        this.topBarMan.update(true);
    }

    public void loadQueryPlan() {
        DBCQueryPlanner planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)this.getDataSource(), DBCQueryPlanner.class);
        ExplainPlanViewer planView = this.getPlanView(null, planner);
        if (planView != null) {
            this.showResultsPanel(false);
            if (!planView.loadQueryPlan(planner, planView)) {
                this.closeActiveTab();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explainQueryPlan() {
        if (!this.canProcessQueries()) {
            return;
        }
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                listener.beforeQueryPlanExplain();
            }
        }
        SQLScriptElement scriptElement = this.extractActiveQuery();
        if (scriptElement == null) {
            this.setStatus(SQLEditorMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
            return;
        }
        if (!(scriptElement instanceof SQLQuery)) {
            this.setStatus("Can't explain plan for command", DBPMessageType.ERROR);
            return;
        }
        this.explainQueryPlan((SQLQuery)scriptElement);
    }

    private void explainQueryPlan(SQLQuery sqlQuery) {
        this.showResultsPanel(false);
        DBCQueryPlanner planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)this.getDataSource(), DBCQueryPlanner.class);
        DBCPlanStyle planStyle = planner.getPlanStyle();
        if (planStyle == DBCPlanStyle.QUERY) {
            this.explainPlanFromQuery(planner, sqlQuery);
        } else if (planStyle == DBCPlanStyle.OUTPUT) {
            this.explainPlanFromQuery(planner, sqlQuery);
            this.showOutputPanel(true);
        } else {
            ExplainPlanViewer planView = this.getPlanView(sqlQuery, planner);
            if (planView != null) {
                planView.explainQueryPlan(sqlQuery, planner);
            }
        }
    }

    private void showResultsPanel(boolean createQueryProcessor) {
        if (this.resultsSash.getMaximizedControl() != null) {
            this.toggleResultPanel(false, createQueryProcessor);
        }
        UIUtils.syncExec(() -> {
            if (this.resultsSash.isDownHidden()) {
                this.resultsSash.showDown();
            }
        });
    }

    private ExplainPlanViewer getPlanView(SQLQuery sqlQuery, DBCQueryPlanner planner) {
        if (planner == null) {
            DBWorkbench.getPlatformUI().showError("Execution plan", "Execution plan explain isn't supported by current datasource");
            return null;
        }
        if (sqlQuery != null && !this.transformQueryWithParameters(sqlQuery)) {
            return null;
        }
        ExplainPlanViewer planView = null;
        if (sqlQuery != null) {
            for (CTabItem item : this.resultTabs.getItems()) {
                ExplainPlanViewer pv;
                Object object = item.getData();
                if (!(object instanceof ExplainPlanViewer) || (pv = (ExplainPlanViewer)((Object)object)).getQuery() == null || !pv.getQuery().equals((Object)sqlQuery)) continue;
                this.setResultTabSelection(item);
                planView = pv;
                break;
            }
        }
        if (planView == null) {
            int maxPlanNumber = 0;
            for (CTabItem item : this.resultTabs.getItems()) {
                if (!(item.getData() instanceof ExplainPlanViewer)) continue;
                maxPlanNumber = Math.max(maxPlanNumber, ((ExplainPlanViewer)((Object)item.getData())).getPlanNumber());
            }
            planView = new ExplainPlanViewer((IWorkbenchPart)this, this, (Composite)this.resultTabs, ++maxPlanNumber);
            CTabItem item = new CTabItem(this.resultTabs, 64);
            item.setControl(planView.getControl());
            item.setText(SQLEditorMessages.editors_sql_error_execution_plan_title + " - " + maxPlanNumber);
            if (sqlQuery != null) {
                String preparedText = sqlQuery.getText().replaceAll("[\n\r\t]{3,}", "");
                if (preparedText.length() > 300) {
                    item.setToolTipText(preparedText.substring(0, 300) + "...");
                } else {
                    item.setToolTipText(preparedText);
                }
            }
            item.setImage(IMG_EXPLAIN_PLAN);
            item.setData((Object)planView);
            item.addDisposeListener(this.resultTabDisposeListener);
            UIUtils.disposeControlOnItemDispose((CTabItem)item);
            this.setResultTabSelection(item);
        }
        return planView;
    }

    private void explainPlanFromQuery(DBCQueryPlanner planner, SQLQuery sqlQuery) {
        String[] planQueryString = new String[1];
        DBRRunnableWithProgress queryObtainTask = monitor -> {
            DBCQueryPlannerConfiguration configuration = ExplainPlanViewer.makeExplainPlanConfiguration(monitor, planner);
            if (configuration == null) {
                return;
            }
            try (DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, "Prepare plan query");){
                DBCPlan plan = planner.planQueryExecution(session, sqlQuery.getText(), configuration);
                planQueryString[0] = plan.getPlanQueryString();
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Explain error", "Failed to explain execution plan", (Throwable)e);
            }
        };
        if (RuntimeUtils.runTask((DBRRunnableWithProgress)queryObtainTask, (String)"Retrieve plan query", (long)5000L) && !CommonUtils.isEmpty((String)planQueryString[0])) {
            SQLQuery planQuery = new SQLQuery(this.getDataSource(), planQueryString[0]);
            this.processQueries(Collections.singletonList(planQuery), false, true, false, true, null, null);
        }
    }

    public void processSQL(boolean newTab, boolean script) {
        this.processSQL(newTab, script, null, null);
    }

    public boolean processSQL(boolean newTab, boolean script, SQLQueryTransformer transformer, @Nullable SQLQueryListener queryListener) {
        return this.processSQL(newTab, script, false, transformer, queryListener);
    }

    public boolean processSQL(boolean newTab, boolean script, boolean executeFromPosition) {
        return this.processSQL(newTab, script, executeFromPosition, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSQL(boolean newTab, boolean script, boolean executeFromPosition, SQLQueryTransformer transformer, @Nullable SQLQueryListener queryListener) {
        List<SQLScriptElement> elements;
        IDocument document = this.getDocument();
        if (document == null) {
            this.setStatus(SQLEditorMessages.editors_sql_status_cant_obtain_document, DBPMessageType.ERROR);
            return false;
        }
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                listener.beforeQueryExecute(script, newTab);
            }
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (script) {
            if (executeFromPosition) {
                elements = this.extractScriptQueries(selection.getOffset(), document.getLength(), true, false, true);
                elements.removeFirst();
                elements.addFirst(this.extractActiveQuery());
            } else {
                elements = selection != null && selection.getLength() > 1 ? this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true) : this.extractScriptQueries(0, document.getLength(), true, false, true);
            }
        } else {
            SQLScriptElement sqlQuery = this.extractActiveQuery();
            if (sqlQuery == null) {
                ResultSetViewer activeViewer = this.getActiveResultSetViewer();
                if (activeViewer != null) {
                    activeViewer.setStatus(SQLEditorMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
                }
                return false;
            }
            elements = Collections.singletonList(sqlQuery);
        }
        try {
            DBPDataSource dataSource;
            if (transformer != null && (dataSource = this.getDataSource()) != null) {
                ArrayList<SQLScriptElement> xQueries = new ArrayList<SQLScriptElement>(elements.size());
                for (SQLScriptElement element : elements) {
                    if (element instanceof SQLQuery) {
                        SQLQuery query = transformer.transformQuery(dataSource, this.getSyntaxManager(), (SQLQuery)element);
                        if (!CommonUtils.isEmpty((Collection)query.getParameters())) {
                            query.setParameters(this.parseQueryParameters(query));
                        }
                        xQueries.add((SQLScriptElement)query);
                        continue;
                    }
                    xQueries.add(element);
                }
                elements = xQueries;
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Bad query", "Can't execute query", (Throwable)e);
            return false;
        }
        if (!CommonUtils.isEmpty(elements)) {
            return this.processQueries(elements, script, newTab, false, true, queryListener, null);
        }
        return false;
    }

    public void exportDataFromQuery(@Nullable SQLScriptContext sqlScriptContext) {
        List<SQLScriptElement> elements = this.getSelectedQueries();
        if (!elements.isEmpty()) {
            this.processQueries(elements, false, false, true, true, null, sqlScriptContext);
        } else {
            DBWorkbench.getPlatformUI().showError("Extract data", "Choose one or more queries to export from");
        }
    }

    @NotNull
    public List<SQLScriptElement> getSelectedQueries() {
        ArrayList<SQLScriptElement> elements = new ArrayList<SQLScriptElement>();
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (selection.getLength() > 1) {
            elements.addAll(this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true));
        } else {
            SQLScriptElement query = this.extractActiveQuery();
            if (query != null) {
                elements.add(query);
            }
        }
        return elements;
    }

    public boolean processQueries(@NotNull List<SQLScriptElement> queries, boolean forceScript, boolean newTab, boolean export, boolean checkSession, @Nullable SQLQueryListener queryListener, @Nullable SQLScriptContext context) {
        boolean isSingleQueryNotScript;
        if (queries.isEmpty()) {
            return false;
        }
        if (!this.canProcessQueries()) {
            return false;
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (checkSession) {
            try {
                boolean finalNewTab = newTab;
                DBRProgressListener connectListener = status -> {
                    if (!status.isOK() || container == null || !container.isConnected()) {
                        DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_obtain_session, null, status);
                        return;
                    }
                    this.updateExecutionContext(() -> UIUtils.syncExec(() -> this.processQueries(queries, forceScript, finalNewTab, export, false, queryListener, context)));
                };
                if (!this.checkSession(connectListener)) {
                    return false;
                }
            }
            catch (DBException ex) {
                ResultSetViewer viewer = this.getActiveResultSetViewer();
                if (viewer != null) {
                    viewer.setStatus(ex.getMessage(), DBPMessageType.ERROR);
                }
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_obtain_session, ex.getMessage());
                return false;
            }
        }
        if (this.dataSourceContainer == null) {
            return false;
        }
        if (!this.dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EXECUTE_SCRIPTS)) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_permissions_query_message);
            return false;
        }
        if (this.dataSourceContainer.isConnectionReadOnly() && queries.stream().anyMatch(q -> {
            SQLQuery sqlQuery;
            return q instanceof SQLQuery && (sqlQuery = (SQLQuery)q).isMutatingStatement();
        })) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_readonly_query_message);
            return false;
        }
        SQLScriptContext scriptContext = context;
        if (scriptContext == null) {
            scriptContext = this.createScriptContext();
        }
        if (this.stopDangerousQueriesExecutionConfirmation(queries)) {
            return false;
        }
        boolean isSingleQuery = queries.size() == 1;
        boolean bl = isSingleQueryNotScript = isSingleQuery && !forceScript;
        if (!this.isHideQueryText() && this.resultsSash.getMaximizedControl() != null) {
            this.resultsSash.setMaximizedControl(null);
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnExecute") && this.isDirty()) {
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.clearOutputBeforeExecute")) {
            this.outputViewer.clearOutput();
        }
        boolean replaceCurrentTab = this.getActivePreferenceStore().getBoolean("SQLEditor.resultSet.replaceCurrentTab");
        if (!export && this.curQueryProcessor != null) {
            CTabItem selectedTab;
            CTabItem tabItem;
            boolean needAnotherQueryProcessor;
            boolean noQueryProcessors;
            if (this.isResultSetAutoFocusEnabled && !newTab && (!isSingleQueryNotScript || isSingleQueryNotScript && !replaceCurrentTab)) {
                int tabsClosed = this.closeExtraResultTabs(null, true, false);
                if (tabsClosed == 1) {
                    return false;
                }
                if (tabsClosed == 3) {
                    newTab = true;
                }
            }
            boolean hasRunningJobs = !(noQueryProcessors = this.queryProcessors.isEmpty()) && this.curQueryProcessor.getRunningJobs() > 0;
            boolean hasPinnedTabs = !noQueryProcessors && this.curQueryProcessor.hasPinnedTabs();
            boolean bl2 = needAnotherQueryProcessor = !noQueryProcessors && this.useTabPerQuery(isSingleQueryNotScript) && !(this.curQueryProcessor instanceof MultiTabsQueryProcessor);
            if (newTab || noQueryProcessors || hasRunningJobs || hasPinnedTabs || needAnotherQueryProcessor) {
                boolean foundSuitableTab = false;
                boolean anyNotPinnedTab = false;
                if (!newTab && isSingleQueryNotScript) {
                    for (QueryProcessor processor : this.queryProcessors) {
                        if (!processor.hasPinnedTabs() && processor.getRunningJobs() == 0) {
                            foundSuitableTab = true;
                            this.curQueryProcessor = processor;
                            break;
                        }
                        anyNotPinnedTab = anyNotPinnedTab || !processor.hasPinnedTabs();
                    }
                }
                if (!(foundSuitableTab || !newTab && anyNotPinnedTab)) {
                    if (needAnotherQueryProcessor && this.curQueryProcessor.getResultContainers().size() == 1 && !this.curQueryProcessor.getFirstResults().viewer.hasData()) {
                        this.curQueryProcessor.getFirstResults().dispose();
                    }
                    this.createQueryProcessor(true, isSingleQuery, false);
                }
            }
            if (!newTab && isSingleQueryNotScript && this.curQueryProcessor.getResultContainers().size() > 1) {
                this.closeExtraResultTabs(this.curQueryProcessor, false, true);
            }
            if ((tabItem = this.curQueryProcessor.getFirstResults().getResultsTab()) != null && ((selectedTab = this.resultTabs.getSelection()) == null || selectedTab.getData() != this.outputViewer)) {
                this.setResultTabSelection(tabItem);
            }
        }
        if (this.curQueryProcessor == null || newTab && this.useTabPerQuery(isSingleQueryNotScript) == this.curQueryProcessor instanceof SingleTabQueryProcessor) {
            this.createQueryProcessor(true, isSingleQuery, true);
        }
        return this.curQueryProcessor.processQueries(scriptContext, queries, forceScript, false, export, !export && this.getActivePreferenceStore().getBoolean("SQLEditor.resultSet.closeOnError"), queryListener);
    }

    public boolean isActiveQueryRunning() {
        return this.curQueryProcessor != null && this.curQueryProcessor.getRunningJobs() > 0;
    }

    public void cancelActiveQuery() {
        if (this.curQueryProcessor != null && this.isActiveQueryRunning()) {
            this.curQueryProcessor.cancelJob();
        }
    }

    @NotNull
    private SQLScriptContext createScriptContext() {
        Path localFile = EditorUtils.getPathFromInput((Object)this.getEditorInput());
        return new SQLScriptContext(this.globalScriptContext, (DBPContextProvider)this, localFile, (DBCOutputWriter)new OutputLogWriter(), (SQLParametersProvider)new SQLEditorParametersProvider(this.getSite()));
    }

    private boolean stopDangerousQueriesExecutionConfirmation(@NotNull List<SQLScriptElement> queries) {
        boolean isStopDropQueriesConfirmed = this.showDangerousQueriesStopExecutionConfirmation(this.getDropQueries(queries), this::createDropQueryConfirmationDialog);
        return isStopDropQueriesConfirmed || this.showDangerousQueriesStopExecutionConfirmation(this.getDangerousUpdateDeleteQueries(queries), this::createDangerousUpdateDeleteQueryConfirmationDialog);
    }

    @NotNull
    private List<SQLQuery> getDropQueries(@NotNull List<SQLScriptElement> queries) {
        return queries.stream().filter(q -> q instanceof SQLQuery).map(q -> (SQLQuery)q).filter(SQLQuery::isDropDangerous).toList();
    }

    @NotNull
    private List<SQLQuery> getDangerousUpdateDeleteQueries(@NotNull List<SQLScriptElement> queries) {
        return queries.stream().filter(q -> q instanceof SQLQuery).map(q -> (SQLQuery)q).filter(SQLQuery::isDeleteUpdateDangerous).toList();
    }

    private boolean showDangerousQueriesStopExecutionConfirmation(@NotNull List<SQLQuery> dangerousQueries, @NotNull BiFunction<SQLQuery, Integer, Integer> dialogCreator) {
        if (dangerousQueries.isEmpty()) {
            return false;
        }
        if (dangerousQueries.size() == 1) {
            return dialogCreator.apply(dangerousQueries.getFirst(), 5) != 0;
        }
        for (SQLQuery query : dangerousQueries) {
            int dialogResult = dialogCreator.apply(query, 7);
            if (dialogResult == 4) {
                return false;
            }
            if (dialogResult == 0) continue;
            return true;
        }
        return false;
    }

    private int createDropQueryConfirmationDialog(@NotNull SQLQuery dropQuery, int dialogType) {
        return ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)4, (String)"drop_sql", (int)dialogType, (Object[])new Object[]{dropQuery.getText()});
    }

    private int createDangerousUpdateDeleteQueryConfirmationDialog(@NotNull SQLQuery dangerousQuery, int dialogType) {
        String targetName = "multiple rows";
        if (dangerousQuery.getEntityMetadata(false) != null) {
            targetName = dangerousQuery.getEntityMetadata(false).getEntityName();
        }
        return ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)4, (String)"dangerous_sql", (int)dialogType, (Object[])new Object[]{dangerousQuery.getType().name(), targetName});
    }

    private void setStatus(String status, DBPMessageType messageType) {
        ResultSetViewer resultsView = this.getActiveResultSetViewer();
        if (resultsView != null) {
            resultsView.setStatus(status, messageType);
        }
    }

    private int closeExtraResultTabs(@Nullable QueryProcessor queryProcessor, boolean confirmClose, boolean keepFirstTab) {
        Object i2;
        ArrayList<CTabItem> tabsToClose = new ArrayList<CTabItem>();
        QueryProcessor processor = null;
        for (Object item : this.resultTabs.getItems()) {
            if (item.getData() instanceof QueryResultsContainer) {
                processor = ((QueryResultsContainer)item.getData()).queryProcessor;
            } else if (item.getData() instanceof QueryProcessor) {
                processor = (QueryProcessor)item.getData();
            }
            if (item.getData() instanceof QueryProcessingComponent && item.getShowClose() && !this.isPinned((CTabItem)item)) {
                if (queryProcessor != null && queryProcessor != processor || queryProcessor != null && queryProcessor.resultContainers.size() < 2 && keepFirstTab) continue;
                tabsToClose.add((CTabItem)item);
                continue;
            }
            if (!(item.getData() instanceof ExplainPlanViewer)) continue;
            tabsToClose.add((CTabItem)item);
        }
        if (tabsToClose.size() > 1 || tabsToClose.size() == 1 && keepFirstTab) {
            int confirmResult = 2;
            if (confirmClose && ((confirmResult = ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)4, (String)"close_result_tabs", (int)6, (Object[])new Object[]{tabsToClose.size()})) == 1 || confirmResult < 0)) {
                return 1;
            }
            if (confirmResult == 2) {
                for (int i2 = 0; i2 < tabsToClose.size(); ++i2) {
                    Object item;
                    if (i2 == 0 && (item = ((CTabItem)tabsToClose.getFirst()).getData()) instanceof SingleTabQueryProcessor) {
                        SingleTabQueryProcessor sqp = (SingleTabQueryProcessor)item;
                        if (keepFirstTab) {
                            ArrayList<QueryResultsContainer> results = new ArrayList<QueryResultsContainer>(sqp.getResultContainers());
                            results.stream().skip(1L).forEach(QueryResultsContainer::dispose);
                            continue;
                        }
                    }
                    if (i2 == 0 && keepFirstTab) continue;
                    ((CTabItem)tabsToClose.get(i2)).dispose();
                }
            }
            return confirmResult;
        }
        if (tabsToClose.size() == 1 && (i2 = ((CTabItem)tabsToClose.getFirst()).getData()) instanceof SingleTabQueryProcessor) {
            SingleTabQueryProcessor sqp = (SingleTabQueryProcessor)i2;
            ArrayList<QueryResultsContainer> results = new ArrayList<QueryResultsContainer>(sqp.getResultContainers());
            results.forEach(QueryResultsContainer::dispose);
            ((CTabItem)tabsToClose.getFirst()).dispose();
        }
        return 9;
    }

    public boolean transformQueryWithParameters(SQLQuery query) {
        return this.createScriptContext().fillQueryParameters(query, () -> null, false);
    }

    public void checkSessionAndConnect(DBRProgressListener onFinish) throws DBException {
        if (this.getDataSourceContainer() != null && this.getDataSourceContainer().isConnected() && this.getExecutionContext() != null) {
            if (onFinish != null) {
                onFinish.onTaskFinished(Status.OK_STATUS);
            }
        } else {
            this.checkSession(status -> {
                if (status.isOK() && this.getExecutionContext() == null) {
                    status = GeneralUtils.makeErrorStatus((String)"Failed to create execution context after session check");
                }
                if (onFinish != null) {
                    onFinish.onTaskFinished(status);
                }
            });
        }
    }

    private boolean checkSession(DBRProgressListener onFinish) throws DBException {
        DBPDataSourceContainer ds = this.getDataSourceContainer();
        if (ds == null) {
            throw new DBException("No active connection");
        }
        if (!ds.isConnected()) {
            boolean doConnect = ds.getPreferenceStore().getBoolean("database.editor.connect.on.execute");
            if (doConnect) {
                return this.checkConnected(true, onFinish);
            }
            throw new DBException("Disconnected from database");
        }
        DBPDataSource dataSource = ds.getDataSource();
        if (dataSource != null && this.executionContextProvider == null && SQLEditorUtils.isOpenSeparateConnection(ds) && this.isolatedExecutionContext == null) {
            this.initSeparateConnection(dataSource, () -> onFinish.onTaskFinished(Status.OK_STATUS), false);
            return this.isolatedExecutionContext != null;
        }
        return true;
    }

    private void fireDataSourceChange() {
        this.updateExecutionContext(null);
        UIUtils.syncExec(this::onDataSourceChange);
    }

    protected void onDataSourceChange() {
        this.onDataSourceChange(true);
    }

    protected void onDataSourceChange(boolean contextChanged) {
        ResultSetViewer rsv;
        DBCExecutionContext executionContext;
        if (contextChanged) {
            this.reloadSyntaxRules();
        }
        if (this.resultsSash == null || this.resultsSash.isDisposed()) {
            return;
        }
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.resultsSash);
        if (this.sqlEditorPanel != null) {
            DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.sqlEditorPanel);
        }
        if (this.resultTabs != null) {
            DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.resultTabs);
        }
        if ((executionContext = this.getExecutionContext()) != null) {
            EditorUtils.setInputDataSource((IEditorInput)this.getEditorInput(), (DatabaseEditorContext)new SQLNavigatorContext(executionContext));
        }
        this.refreshActions();
        this.refreshEditorIconAndTitle();
        if (this.syntaxLoaded && this.lastExecutionContext == executionContext) {
            return;
        }
        if (this.curResultsContainer != null && (rsv = this.curResultsContainer.getResultSetController()) != null) {
            if (executionContext == null) {
                rsv.setStatus(ModelMessages.error_not_connected_to_database);
            } else {
                rsv.setStatus(SQLEditorMessages.editors_sql_staus_connected_to + executionContext.getDataSource().getContainer().getName() + "'");
            }
        }
        if (this.lastExecutionContext == null || executionContext == null || this.lastExecutionContext.getDataSource() != executionContext.getDataSource()) {
            SQLEditorPropertyTester.firePropertyChange("canExecute");
            SQLEditorPropertyTester.firePropertyChange("canExplain");
        }
        if (!this.isHideQueryText()) {
            if (dsContainer == null) {
                this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
            } else if (this.curQueryProcessor != null && this.curQueryProcessor.getFirstResults().hasData()) {
                this.resultsSash.setMaximizedControl(null);
            }
        }
        this.lastExecutionContext = executionContext;
        this.syntaxLoaded = true;
        this.loadActivePreferenceSettings();
        if (dsContainer != null) {
            this.globalScriptContext.loadVariables(dsContainer.getDriver(), null);
        } else {
            this.globalScriptContext.clearVariables();
        }
        if (this.outputViewer != null && executionContext != null) {
            this.outputViewer.setExecutionContext(executionContext);
        }
    }

    public void refreshEditorIconAndTitle() {
        if (this.tmpImage != null) {
            this.tmpImage.dispose();
            this.tmpImage = null;
        }
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        this.setPartName(this.getEditorName());
        Object bottomRight = this.getExecutionContext() == null ? (dsContainer instanceof DBPStatefulObject && ((DBPStatefulObject)dsContainer).getObjectState() == DBSObjectState.INVALID ? DBIcon.OVER_ERROR : null) : DBIcon.OVER_SUCCESS;
        DBIcon bottomLeft = SQLEditorUtils.isSQLSyntaxParserApplied(this.getEditorInput()) ? null : DBIcon.OVER_RED_LAMP;
        if (this.baseEditorImage == null) {
            this.baseEditorImage = this.getTitleImage();
        }
        if (bottomLeft != null || bottomRight != null) {
            DBIconComposite image = new DBIconComposite((DBPImage)new DBIconBinary(null, this.baseEditorImage), false, null, null, (DBPImage)bottomLeft, (DBPImage)bottomRight);
            this.tmpImage = this.editorImage = DBeaverIcons.getImage((DBPImage)image, (boolean)false);
        } else {
            this.editorImage = this.baseEditorImage;
        }
        this.setTitleImage(this.editorImage);
    }

    public void beforeConnect() {
    }

    public void beforeDisconnect() {
        this.closeAllJobs();
    }

    @Override
    public void dispose() {
        if (this.extraPresentationManager != null) {
            this.extraPresentationManager.dispose();
        }
        this.releaseContainer();
        this.closeAllJobs();
        IEditorInput editorInput = this.getEditorInput();
        IFile sqlFile = EditorUtils.getFileFromInput((IEditorInput)editorInput);
        this.logViewer = null;
        this.outputViewer = null;
        this.queryProcessors.clear();
        this.curResultsContainer = null;
        this.curQueryProcessor = null;
        ListIterator<SQLEditorAddIn> addInsIterator = this.addIns.listIterator(this.addIns.size());
        while (addInsIterator.hasPrevious()) {
            SQLEditorAddIn addIn = addInsIterator.previous();
            try {
                addIn.cleanup(this);
            }
            catch (Throwable ex) {
                log.error((Object)"Error during SQL editor add-in cleanup", ex);
            }
        }
        super.dispose();
        if (sqlFile != null && !PlatformUI.getWorkbench().isClosing() && !DBWorkbench.isDistributed()) {
            this.deleteFileIfEmpty(sqlFile);
        }
        UIUtils.dispose((Resource)this.tmpImage);
        this.tmpImage = null;
        this.baseEditorImage = null;
        this.editorImage = null;
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (!this.extraPresentationManager.presentations.isEmpty()) {
            for (Map.Entry<SQLPresentationDescriptor, SQLEditorPresentation> entry : this.extraPresentationManager.presentations.entrySet()) {
                final SQLPresentationDescriptor pd = entry.getKey();
                if (pd == this.extraPresentationManager.activePresentationDescriptor) continue;
                menu.insertAfter("sql.extras", (IAction)new Action(pd.getDescription(), DBeaverIcons.getImageDescriptor((DBPImage)pd.getIcon())){

                    public void run() {
                        SQLEditor.this.showExtraPresentation(pd);
                    }
                });
            }
            menu.insertAfter("sql.extras", (IContributionItem)new Separator("presentations"));
        }
    }

    private void deleteFileIfEmpty(IFile sqlFile) {
        if (sqlFile == null || !sqlFile.exists()) {
            return;
        }
        SQLPreferenceConstants.EmptyScriptCloseBehavior emptyScriptCloseBehavior = SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(this.getActivePreferenceStore().getString("script.delete.empty"));
        if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.NOTHING) {
            return;
        }
        if (!sqlFile.exists() || ResourceUtils.getFileLength((IResource)sqlFile) != 0L) {
            return;
        }
        try {
            Object[] fileHistory;
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.DELETE_NEW && !ArrayUtils.isEmpty((Object[])(fileHistory = sqlFile.getHistory((IProgressMonitor)monitor)))) {
                for (Object historyItem : fileHistory) {
                    try (InputStream contents = historyItem.getContents();){
                        int cValue = contents.read();
                        if (cValue == -1) continue;
                        return;
                    }
                }
            }
            if (sqlFile.exists()) {
                log.debug((Object)("Delete empty SQL script '" + sqlFile.getFullPath().toOSString() + "'"));
                sqlFile.delete(true, (IProgressMonitor)monitor);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error deleting empty script file", (Throwable)e);
        }
    }

    private void closeAllJobs() {
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.closeJob();
        }
    }

    private int getTotalQueryRunning() {
        int jobsRunning = 0;
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            jobsRunning += queryProcessor.getRunningJobs();
        }
        return jobsRunning;
    }

    public void handleDataSourceEvent(@NotNull DBPEvent event) {
        boolean registryEvent;
        boolean dsEvent = event.getObject() == this.getDataSourceContainer();
        boolean objectEvent = event.getObject() != null && event.getObject().getDataSource() == this.getDataSource();
        boolean bl = registryEvent = this.getDataSourceContainer() != null && event.getData() == this.getDataSourceContainer().getRegistry();
        if (dsEvent || objectEvent || registryEvent) {
            UIUtils.asyncExec(() -> {
                switch (event.getAction()) {
                    case OBJECT_REMOVE: {
                        if (!dsEvent) break;
                        this.setDataSourceContainer(null);
                        break;
                    }
                    case OBJECT_UPDATE: 
                    case OBJECT_SELECT: {
                        if (!objectEvent) break;
                        this.setPartName(this.getEditorName());
                        this.firePropertyChange(1);
                        break;
                    }
                    case BEFORE_CONNECT: 
                    case AFTER_CONNECT: {
                        break;
                    }
                }
                this.updateExecutionContext(null);
                boolean contextChanged = this.isContextChanged(event);
                this.onDataSourceChange(contextChanged);
            });
        }
    }

    private boolean isContextChanged(DBPEvent event) {
        DBCExecutionContextDefaults ctxDefault;
        DBCExecutionContext execContext;
        boolean contextChanged;
        DBPEvent.Action eventAction = event.getAction();
        DBSObject eventObject = event.getObject();
        boolean isEditorContext = eventObject == this.getDataSourceContainer() || event.getData() == this.getExecutionContext();
        boolean bl = contextChanged = isEditorContext && eventAction.equals((Object)DBPEvent.Action.OBJECT_UPDATE);
        if (!contextChanged && isEditorContext && eventAction.equals((Object)DBPEvent.Action.OBJECT_SELECT) && event.getEnabled().booleanValue() && (execContext = this.getExecutionContext()) != null && (ctxDefault = execContext.getContextDefaults()) != null && eventObject != null) {
            boolean defaultChanged;
            boolean bl2 = defaultChanged = eventObject == ctxDefault.getDefaultCatalog() || eventObject == ctxDefault.getDefaultSchema();
            if (this.lastExecutionContext != this.isolatedExecutionContext || defaultChanged) {
                contextChanged = true;
            }
        }
        return contextChanged;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this.isNonPersistentEditor()) {
            int decision = ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)2, (String)"save_sql_console", (int)3, (Object[])new Object[0]);
            if (decision == 2) {
                this.saveAsNewScript();
            }
            return;
        }
        if (!EditorUtils.isInAutoSaveJob()) {
            monitor.beginTask("Save data changes...", 1);
            try {
                monitor.subTask("Save '" + this.getPartName() + "' changes...");
                SaveJob saveJob = new SaveJob();
                saveJob.schedule();
                UIUtils.waitJobCompletion((AbstractJob)saveJob, (IProgressMonitor)monitor);
                if (!saveJob.success.booleanValue()) {
                    monitor.setCanceled(true);
                    return;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (this.extraPresentationManager.activePresentation instanceof ISaveablePart) {
            ((ISaveablePart)this.extraPresentationManager.activePresentation).doSave(monitor);
        }
        super.doSave(monitor);
        this.updateDataSourceContainer();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.saveToExternalFile();
    }

    private synchronized void doScriptAutoSave() {
        if (this.scriptAutoSavejob == null) {
            this.scriptAutoSavejob = new ScriptAutoSaveJob();
        } else {
            this.scriptAutoSavejob.cancel();
        }
        this.scriptAutoSavejob.schedule(1000L);
    }

    public int promptToSaveOnClose() {
        UIServiceConnections serviceConnections;
        int jobsRunning = this.getTotalQueryRunning();
        if (jobsRunning > 0) {
            log.warn((Object)("There are " + jobsRunning + " SQL job(s) still running in the editor"));
            if (ConfirmationDialog.confirmAction(null, (int)4, (String)"close_running_query", (int)3, (Object[])new Object[]{jobsRunning}) != 2) {
                return 2;
            }
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return rsv.promptToSaveOnClose();
            }
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.cancelJob();
            queryProcessor.getCurJobRunning().updateAndGet(i -> 0);
        }
        if (this.isolatedExecutionContext != null && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null && !serviceConnections.checkAndCloseActiveTransaction(new DBCExecutionContext[]{this.isolatedExecutionContext})) {
            return 2;
        }
        if (this.isNonPersistentEditor()) {
            return 1;
        }
        this.updateDirtyFlag();
        IFile fileFromInput = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnClose") && (fileFromInput == null || fileFromInput.isSynchronized(0))) {
            return 0;
        }
        if (super.isDirty() || this.extraPresentationManager.activePresentation instanceof ISaveablePart && ((ISaveablePart)this.extraPresentationManager.activePresentation).isDirty()) {
            return 3;
        }
        return 0;
    }

    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        IDocumentProviderExtension5 providerExt;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension5 && (providerExt = (IDocumentProviderExtension5)provider).isNotSynchronizedException((Object)this.getEditorInput(), exception)) {
            String[] buttons = new String[]{SQLEditorMessages.update_conflict_message_overwrite, SQLEditorMessages.update_conflict_message_revert, WorkbenchMessages.SaveableHelper_Cancel};
            MessageDialog dialog = new MessageDialog(this, UIUtils.getActiveShell(), WorkbenchMessages.Save_Resource, null, NLS.bind((String)SQLEditorMessages.update_conflict_message, (Object)this.getEditorInput().getName()), 0, 0, buttons){

                protected int getShellStyle() {
                    return 0x10010860 | 17.getDefaultOrientation();
                }
            };
            int response = dialog.open();
            if (response == 0) {
                this.performSave(true, progressMonitor);
            } else if (response == 1) {
                this.doRevertToSaved();
            } else if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
        } else {
            super.handleExceptionOnSave(exception, progressMonitor);
        }
    }

    protected void afterSaveToFile(File saveFile) {
        try {
            IFileStore fileStore = EFS.getStore((URI)saveFile.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)new SQLNavigatorContext(this.getDataSourceContainer(), this.getExecutionContext()));
            this.setInput((IEditorInput)input);
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError("File save", "Can't open SQL editor from external file", (Throwable)e);
        }
    }

    public boolean supportsRename() {
        return true;
    }

    public void saveToExternalFile() {
        this.saveToExternalFile(this.getScriptDirectory());
    }

    public void saveAsNewScript() {
        SQLNavigatorContext context = new SQLNavigatorContext(this.getDataSourceContainer(), this.getExecutionContext());
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        try {
            IFile script = SQLEditorUtils.createNewScript(this.getProject(), null, context);
            byte[] contents = document.get().getBytes(ResourcesPlugin.getEncoding());
            script.setContents((InputStream)new ByteArrayInputStream(contents), 1, (IProgressMonitor)new NullProgressMonitor());
            FileEditorInput input = new FileEditorInput(script);
            EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)context);
            this.setInput((IEditorInput)input);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("File save", "Can't save as new script file", (Throwable)e);
        }
    }

    @Nullable
    private String getScriptDirectory() {
        URI locationURI;
        IFolder root;
        File inputFile = EditorUtils.getLocalFileFromInput((Object)this.getEditorInput());
        if (inputFile != null) {
            return inputFile.getParent();
        }
        DBPWorkspaceDesktop workspace = DBPPlatformDesktop.getInstance().getWorkspace();
        DBPProject activeProject = workspace.getActiveProject();
        IFolder iFolder = root = activeProject == null ? null : workspace.getResourceDefaultRoot(activeProject, ScriptsHandlerImpl.class, false);
        if (root != null && IOUtils.isLocalURI((URI)(locationURI = root.getLocationURI()))) {
            return new File(locationURI).toString();
        }
        return null;
    }

    @Nullable
    private ResultSetViewer getActiveResultSetViewer() {
        if (this.curResultsContainer != null) {
            return this.curResultsContainer.getResultSetController();
        }
        return null;
    }

    void showScriptPositionRuler(boolean show) {
        IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
        if (columnSupport != null) {
            RulerColumnDescriptor positionColumn = RulerColumnRegistry.getDefault().getColumnDescriptor("org.jkiss.dbeaver.ui.editors.columns.script.position");
            columnSupport.setColumnVisible(positionColumn, show);
        }
    }

    private void showStatementInEditor(SQLQuery query, boolean select) {
        UIUtils.runUIJob((String)"Select SQL query in editor", monitor -> {
            if (this.isDisposed()) {
                return;
            }
            if (select) {
                this.selectAndReveal(query.getOffset(), query.getLength());
                this.setStatus(query.getText(), DBPMessageType.INFORMATION);
            } else {
                this.getSourceViewer().revealRange(query.getOffset(), query.getLength());
            }
        });
    }

    @Override
    public void reloadSyntaxRules() {
        super.reloadSyntaxRules();
        if (this.outputViewer != null) {
            this.outputViewer.refreshStyles();
        }
    }

    private QueryProcessor createQueryProcessor(boolean setSelection, boolean singleQuery, boolean makeDefault) {
        CTabItem tabItem;
        QueryProcessor queryProcessor;
        this.curQueryProcessor = queryProcessor = this.useTabPerQuery(singleQuery) ? new MultiTabsQueryProcessor(this, singleQuery, makeDefault) : new SingleTabQueryProcessor(this, makeDefault);
        this.curResultsContainer = queryProcessor.getFirstResults();
        if (setSelection && (tabItem = this.curResultsContainer.getResultsTab()) != null) {
            this.setResultTabSelection(tabItem);
        }
        return queryProcessor;
    }

    @Override
    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        switch (event.getProperty()) {
            case "script.sql.delimiter": 
            case "script.sql.ignoreNativeDelimiter": 
            case "script.sql.delimiter.blank": 
            case "sql.parameter.enabled": 
            case "sql.parameter.mark": 
            case "sql.parameter.anonymous.enabled": 
            case "sql.variables.enabled": 
            case "sql.parameter.prefix": 
            case "sql.command.prefix": {
                this.reloadSyntaxRules();
                return;
            }
            case "SQLEditor.resultSet.orientation": {
                this.updateResultSetOrientation();
                return;
            }
            case "database.editor.separate.connection": {
                DBPDataSource dataSource = this.curDataSource;
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                if (dataSource != null && SQLEditorUtils.isOpenSeparateConnection(dataSource.getContainer())) {
                    this.initSeparateConnection(dataSource, null, false);
                }
                return;
            }
            case "script.title.pattern": {
                this.setPartName(this.getEditorName());
                return;
            }
            case "SQLEditor.resultSet.multipleResultsPerTab": {
                this.updateMultipleResultsPerTabToolItem();
                return;
            }
        }
        UIUtils.asyncExec(() -> {
            if (this.topBarMan != null) {
                this.topBarMan.update(true);
            }
            this.updateMultipleResultsPerTabToolItem();
        });
        this.setCompletionContext(new SQLEditorCompletionContext(this));
        this.fireDataSourceChanged(event);
        super.preferenceChange(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataSourceChanged(DBPPreferenceListener.PreferenceChangeEvent event) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                try {
                    listener.onDataSourceChanged(event);
                }
                catch (Throwable ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    int obtainDesiredTabIndex(boolean makeDefault) {
        int tabCount = this.resultTabs.getItemCount();
        int tabIndex = 0;
        if (!makeDefault) {
            for (int i = tabCount; i > 0; --i) {
                if (!(this.resultTabs.getItem(i - 1).getData() instanceof QueryProcessingComponent)) continue;
                tabIndex = i;
                break;
            }
        }
        return tabIndex;
    }

    @NotNull
    protected QueryResultsDecorator createQueryResultsDecorator(final boolean singleQuery) {
        return new QueryResultsDecorator(){

            public long getDecoratorFeatures() {
                long features = super.getDecoratorFeatures();
                if (!singleQuery) {
                    features |= 0x100L;
                }
                return features;
            }

            public String getEmptyDataDescription() {
                String execQuery = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.statement", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                String execScript = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.script", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                return NLS.bind((String)ResultSetMessages.sql_editor_resultset_filter_panel_control_execute_to_see_result, (Object)execQuery, (Object)execScript);
            }
        };
    }

    int getMaxResultsTabIndex() {
        int maxIndex = 0;
        for (CTabItem tab : this.resultTabs.getItems()) {
            Object object = tab.getData();
            if (object instanceof QueryResultsContainer) {
                QueryResultsContainer qrc = (QueryResultsContainer)object;
                maxIndex = Math.max(maxIndex, qrc.getResultSetIndex());
            }
            if (!((object = tab.getData()) instanceof SingleTabQueryProcessor)) continue;
            SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)object;
            List<QueryResultsContainer> results = stqp.getResultContainers();
            maxIndex = Math.max(maxIndex, results.getLast().getResultSetIndex());
        }
        return maxIndex;
    }

    String getResultsTabName(int resultSetNumber, int queryIndex, String name) {
        Object tabName = name;
        if (CommonUtils.isEmpty((String)tabName)) {
            tabName = SQLEditorMessages.editors_sql_data_grid;
        }
        tabName = (String)tabName + " " + (queryIndex + 1);
        if (resultSetNumber > 0) {
            tabName = (String)tabName + " (" + (resultSetNumber + 1) + ")";
        }
        return tabName;
    }

    public void updateDirtyFlag() {
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpQueryServerOutput(@Nullable DBCExecutionResult result) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            DBPDataSource dataSource = executionContext.getDataSource();
            DBCServerOutputReader outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
            if (outputReader == null && result != null) {
                outputReader = new DefaultServerOutputReader();
            }
            if (outputReader != null && outputReader.isServerOutputEnabled()) {
                List<ServerOutputInfo> list = this.serverOutputs;
                synchronized (list) {
                    this.serverOutputs.add(new ServerOutputInfo(outputReader, executionContext, result));
                }
            }
        }
    }

    private void runPostExecuteActions(@Nullable SQLQueryResult result) {
        this.showResultsPanel(true);
    }

    private void updateOutputViewerIcon(boolean alert) {
        Image image = alert ? IMG_OUTPUT_ALERT : IMG_OUTPUT;
        CTabItem outputItem = UIUtils.getTabItem((CTabFolder)this.resultTabs, (Object)((Object)this.outputViewer));
        if (outputItem != null && outputItem != this.resultTabs.getSelection()) {
            outputItem.setImage(image);
        } else {
            ToolItem viewItem = this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.show.output");
            if (viewItem != null) {
                viewItem.setImage(image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnDataListeners(@NotNull QueryResultsContainer container) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            SQLScriptElement query = container.getQuery();
            String queryText = query == null ? "" : query.getOriginalText();
            for (SQLEditorListener listener : this.listeners) {
                try {
                    listener.onDataReceived(this.getContextPrefStore(container), container.getResultSetController().getModel(), queryText);
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnQueryResultListeners(@NotNull QueryResultsContainer container, @NotNull SQLQueryResult result) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                try {
                    listener.onQueryResult(this.getContextPrefStore(container), result);
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        }
    }

    @NotNull
    private DBPPreferenceStore getContextPrefStore(@NotNull QueryResultsContainer container) {
        DBCExecutionContext context = container.getExecutionContext();
        return context != null ? context.getDataSource().getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
    }

    @Nullable
    private String getTransactionStatusText() throws DBCException {
        if (this.dataSourceContainer == null) {
            return null;
        }
        long lastUserActivityTime = DataSourceMonitorJob.getLastUserActivityTime();
        if (lastUserActivityTime < 0L) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedSeconds = (currentTime - lastUserActivityTime) / 1000L;
        if (elapsedSeconds < 60L) {
            return null;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext);
        QMTransactionState txnState = QMUtils.getTransactionState((DBCExecutionContext)executionContext);
        boolean isTransactionInProgress = txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit() && txnState.getUpdateCount() > 0;
        long disconnectTimeoutSeconds = DataSourceMonitorJob.getDisconnectTimeoutSeconds((DBPDataSourceContainer)this.dataSourceContainer);
        long rollbackTimeoutSeconds = DataSourceMonitorJob.getTransactionTimeoutSeconds((DBPDataSourceContainer)this.dataSourceContainer);
        if (isTransactionInProgress && rollbackTimeoutSeconds > 0L && rollbackTimeoutSeconds > elapsedSeconds && (disconnectTimeoutSeconds <= 0L || rollbackTimeoutSeconds < disconnectTimeoutSeconds) && !DBExecUtils.isExecutionInProgress((DBPDataSource)this.dataSourceContainer.getDataSource())) {
            return NLS.bind((String)SQLEditorMessages.sql_editor_status_bar_rollback_label, (Object)DurationFormatter.format((Duration)Duration.ofSeconds(rollbackTimeoutSeconds - elapsedSeconds), (DurationFormat)DurationFormat.MEDIUM));
        }
        if (disconnectTimeoutSeconds > 0L && disconnectTimeoutSeconds > elapsedSeconds) {
            return NLS.bind((String)SQLEditorMessages.sql_editor_status_bar_disconnect_label, (Object)DurationFormatter.format((Duration)Duration.ofSeconds(disconnectTimeoutSeconds - elapsedSeconds), (DurationFormat)DurationFormat.MEDIUM));
        }
        return null;
    }

    public static enum ResultSetOrientation {
        HORIZONTAL(512, SQLEditorMessages.sql_editor_result_set_orientation_horizontal, SQLEditorMessages.sql_editor_result_set_orientation_horizontal_tip, true),
        VERTICAL(256, SQLEditorMessages.sql_editor_result_set_orientation_vertical, SQLEditorMessages.sql_editor_result_set_orientation_vertical_tip, true),
        DETACHED(512, SQLEditorMessages.sql_editor_result_set_orientation_detached, SQLEditorMessages.sql_editor_result_set_orientation_detached_tip, false);

        private final int sashOrientation;
        private final String label;
        private final String description;
        private final boolean supported;

        private ResultSetOrientation(int sashOrientation, String label, String description, boolean supported) {
            this.sashOrientation = sashOrientation;
            this.label = label;
            this.description = description;
            this.supported = supported;
        }

        public int getSashOrientation() {
            return this.sashOrientation;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }

    private class FindReplaceTarget
    extends DynamicFindReplaceTarget {
        private IFindReplaceTarget previousTarget = null;

        private FindReplaceTarget() {
        }

        public IFindReplaceTarget getTarget() {
            boolean focusInEditor;
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            SQLEditorOutputConsoleViewer outputViewer = SQLEditor.this.outputViewer.getViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget() != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor && rsv == null && !outputViewer.getText().isFocusControl() && this.previousTarget != null) {
                boolean bl2 = focusInEditor = textViewer != null && this.previousTarget.equals((Object)textViewer.getFindReplaceTarget());
            }
            if (!focusInEditor) {
                if (rsv != null && rsv.getActivePresentation().getControl().isFocusControl()) {
                    this.previousTarget = (IFindReplaceTarget)rsv.getAdapter(IFindReplaceTarget.class);
                } else if (outputViewer.getControl().isFocusControl()) {
                    this.previousTarget = new StyledTextFindReplaceTarget(outputViewer.getText());
                }
            } else {
                this.previousTarget = textViewer.getFindReplaceTarget();
            }
            return this.previousTarget;
        }
    }

    private class OpenContextJob
    extends AbstractJob {
        private final DBSInstance instance;
        private final Runnable onSuccess;
        private Throwable error;
        private final boolean readDefaultsFromInstance;

        OpenContextJob(DBSInstance instance, Runnable onSuccess, boolean readDefaultsFromInstance) {
            super("Open connection to " + instance.getDataSource().getContainer().getName());
            this.instance = instance;
            this.onSuccess = onSuccess;
            this.readDefaultsFromInstance = readDefaultsFromInstance;
            this.setUser(true);
        }

        public boolean belongsTo(Object family) {
            if (family == this || family == SQLEditor.this.dataSourceContainer) {
                return true;
            }
            return super.belongsTo(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            monitor.beginTask("Open SQLEditor isolated connection", 1);
            try {
                DBCExecutionContextDefaults contextDefaultsDB;
                DBCExecutionContext defaultContext;
                String title = "SQLEditor <" + SQLEditor.this.getEditorInput().getName() + ">";
                monitor.subTask("Open context " + title);
                final DBCExecutionContext newContext = this.instance.openIsolatedContext(monitor, title, this.instance.getDefaultContext(monitor, false));
                String[] contextDefaultNames = null;
                if (this.readDefaultsFromInstance && SQLEditor.this.datasourceChanged && (defaultContext = DBUtils.getDefaultContext((DBSObject)this.instance, (boolean)false)) != null && (contextDefaultsDB = defaultContext.getContextDefaults()) != null) {
                    contextDefaultNames = new String[2];
                    contextDefaultNames[0] = contextDefaultsDB.getDefaultCatalog() != null ? contextDefaultsDB.getDefaultCatalog().getName() : null;
                    String string = contextDefaultNames[1] = contextDefaultsDB.getDefaultSchema() != null ? contextDefaultsDB.getDefaultSchema().getName() : null;
                }
                if (contextDefaultNames == null) {
                    String[] stringArray = contextDefaultNames = SQLEditor.this.isRestoreActiveSchemaFromScript() && this.instance.getDataSource() != null ? EditorUtils.getInputContextDefaults((DBPDataSourceContainer)this.instance.getDataSource().getContainer(), (IEditorInput)SQLEditor.this.getEditorInput()) : null;
                }
                if (!(contextDefaultNames == null || contextDefaultNames.length <= 1 || CommonUtils.isEmpty((String)contextDefaultNames[0]) && CommonUtils.isEmpty((String)contextDefaultNames[1]))) {
                    try {
                        DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)monitor, (DBPDataSource)newContext.getDataSource(), (DBCExecutionContext)newContext, (String)contextDefaultNames[0], null, (String)contextDefaultNames[1]);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("New connection default", "Error setting default catalog/schema for new connection", (Throwable)e);
                    }
                }
                SQLEditor.this.isolatedExecutionContext = newContext;
                new AbstractJob("Notify context change"){

                    @NotNull
                    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                        DBUtils.fireObjectSelect((DBSObject)OpenContextJob.this.instance, (boolean)true, (DBCExecutionContext)newContext);
                        return Status.OK_STATUS;
                    }
                }.schedule(200L);
            }
            catch (DBException e) {
                this.error = e;
            }
            finally {
                monitor.done();
            }
            this.updateContext();
            return Status.OK_STATUS;
        }

        private void updateContext() {
            if (this.error != null) {
                SQLEditor.this.releaseExecutionContext();
                DBWorkbench.getPlatformUI().showError("Open context", "Can't open editor connection", this.error);
            } else {
                if (this.onSuccess != null) {
                    this.onSuccess.run();
                }
                SQLEditor.this.fireDataSourceChange();
            }
        }
    }

    private static class CloseContextJob
    extends AbstractJob {
        private final DBCExecutionContext context;

        CloseContextJob(DBCExecutionContext context) {
            super("Close context " + context.getContextName());
            this.context = context;
            this.setUser(true);
        }

        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            monitor.beginTask("Close SQLEditor isolated connection", 1);
            try {
                UIServiceConnections serviceConnections;
                if (QMUtils.isTransactionActive((DBCExecutionContext)this.context) && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null) {
                    serviceConnections.closeActiveTransaction(monitor, this.context, false);
                }
                monitor.subTask("Close context " + this.context.getContextName());
                DBUtils.closeSafely((AutoCloseable)this.context);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class DynamicSelectionProvider
    extends CompositeSelectionProvider {
        private boolean lastFocusInEditor = true;

        private DynamicSelectionProvider() {
        }

        public ISelectionProvider getProvider() {
            boolean focusInEditor;
            ISelectionProvider selectionProvider;
            if (SQLEditor.this.extraPresentationManager.activePresentation != null && SQLEditor.this.extraPresentationManager.getActivePresentationControl().isFocusControl() && (selectionProvider = SQLEditor.this.extraPresentationManager.activePresentation.getSelectionProvider()) != null) {
                return selectionProvider;
            }
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor) {
                focusInEditor = rsv != null && rsv.getActivePresentation().getControl() != null && rsv.getActivePresentation().getControl().isFocusControl() ? false : this.lastFocusInEditor;
            }
            this.lastFocusInEditor = focusInEditor;
            if (!focusInEditor && rsv != null) {
                return rsv;
            }
            if (textViewer != null) {
                return textViewer.getSelectionProvider();
            }
            return null;
        }
    }

    private class ServerOutputReader
    extends AbstractJob {
        ServerOutputReader() {
            super("Dump server output");
            this.setSystem(true);
        }

        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            if (!DBWorkbench.getPlatform().isShuttingDown() && SQLEditor.this.resultsSash != null && !SQLEditor.this.resultsSash.isDisposed()) {
                try {
                    this.dumpOutput(monitor);
                }
                catch (Exception e) {
                    SQLEditorBase.log.debug((Object)e);
                }
                this.schedule(200L);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpOutput(DBRProgressMonitor monitor) {
            ArrayList<ServerOutputInfo> outputs;
            final SQLEditorOutputViewer currentOutputViewer = SQLEditor.this.outputViewer;
            if (currentOutputViewer == null || currentOutputViewer.isDisposed()) {
                return;
            }
            List<ServerOutputInfo> list = SQLEditor.this.serverOutputs;
            synchronized (list) {
                outputs = new ArrayList<ServerOutputInfo>(SQLEditor.this.serverOutputs);
                SQLEditor.this.serverOutputs.clear();
            }
            final List<PrintWriter> addInWriters = SQLEditor.this.addIns.stream().map(SQLEditorAddIn::getServerOutputConsumer).filter(Objects::nonNull).toList();
            DBCOutputWriter outputWriter = new DBCOutputWriter(){

                public void println(@Nullable DBCOutputSeverity severity, @Nullable String message) {
                    currentOutputViewer.println(severity, message);
                    if (message != null) {
                        for (PrintWriter writer : addInWriters) {
                            writer.println(message);
                        }
                    }
                }

                public void flush() {
                    currentOutputViewer.flush();
                    for (PrintWriter writer : addInWriters) {
                        writer.flush();
                    }
                }
            };
            if (!outputs.isEmpty()) {
                for (ServerOutputInfo info : outputs) {
                    if (monitor.isCanceled()) break;
                    try {
                        info.outputReader.readServerOutput(monitor, info.executionContext, info.result, null, outputWriter);
                    }
                    catch (Exception e) {
                        SQLEditorBase.log.error((Object)e);
                    }
                }
            }
            if (!monitor.isCanceled()) {
                DBCServerOutputReader outputReader = null;
                DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
                if (executionContext != null) {
                    DBPDataSource dataSource = executionContext.getDataSource();
                    outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
                }
                if (outputReader != null && outputReader.isAsyncOutputReadSupported()) {
                    for (QueryProcessor qp : SQLEditor.this.queryProcessors) {
                        SQLQueryJob queryJob = qp.getCurJob();
                        if (queryJob == null) continue;
                        DBCStatement statement = queryJob.getCurrentStatement();
                        try {
                            if (statement == null || statement.isStatementClosed()) continue;
                            outputReader.readServerOutput(monitor, executionContext, null, statement, outputWriter);
                        }
                        catch (DBCException e) {
                            SQLEditorBase.log.error((Object)e);
                        }
                    }
                }
            }
            outputWriter.flush();
            if (currentOutputViewer == null || currentOutputViewer.isDisposed() || !currentOutputViewer.isHasNewOutput()) {
                return;
            }
            currentOutputViewer.resetNewOutput();
            UIUtils.asyncExec(() -> {
                ToolItem toolItem;
                currentOutputViewer.getViewer().scrollToEnd();
                if (SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.outputPanel.autoShow") && (toolItem = SQLEditor.this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.show.output")) != null && !toolItem.getSelection()) {
                    SQLEditor.this.showOutputPanel(true);
                }
            });
        }
    }

    private static final class TransactionStatusUpdateJob
    extends AbstractJob {
        private static final int UPDATE_DELAY_MS = 1000;

        public TransactionStatusUpdateJob() {
            super("Update active transaction status");
            this.setUser(false);
            this.setSystem(true);
        }

        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            IEditorPart iEditorPart;
            IWorkbenchPage page;
            if (monitor.isCanceled() || DBWorkbench.getPlatform().isShuttingDown()) {
                return Status.CANCEL_STATUS;
            }
            IWorkbenchWindow window = UIUtils.findActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (iEditorPart = page.getActiveEditor()) instanceof SQLEditor) {
                SQLEditor editor = (SQLEditor)iEditorPart;
                UIUtils.syncExec(() -> editor.updateStatusField(SQLEditor.STATS_CATEGORY_TRANSACTION_TIMEOUT));
            }
            this.schedule(1000L);
            return Status.OK_STATUS;
        }
    }

    static interface QueryProcessingComponent {
    }

    private class PresentationPanelToggleAction
    extends Action {
        private final SQLPresentationPanelDescriptor panel;

        public PresentationPanelToggleAction(SQLPresentationPanelDescriptor panel) {
            super(panel.getLabel(), 2);
            this.setId(SQLEditor.PANEL_ITEM_PREFIX + panel.getId());
            if (panel.getIcon() != null) {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)panel.getIcon()));
            }
            if (panel.getDescription() != null) {
                this.setToolTipText(panel.getDescription());
            }
            this.panel = panel;
        }

        public void run() {
            this.setChecked(!this.isChecked());
            SQLEditorPresentationPanel panelInstance = SQLEditor.this.extraPresentationManager.panels.get((Object)this.panel);
            if (panelInstance != null && !this.isChecked()) {
                for (CTabItem tabItem : SQLEditor.this.resultTabs.getItems()) {
                    if (tabItem.getData() != panelInstance) continue;
                    tabItem.dispose();
                    return;
                }
            }
            if (panelInstance == null) {
                Control panelControl;
                try {
                    panelInstance = this.panel.createPanel();
                    panelControl = panelInstance.createPanel((Composite)SQLEditor.this.resultTabs, SQLEditor.this, SQLEditor.this.extraPresentationManager.activePresentation);
                }
                catch (DBException e2) {
                    DBWorkbench.getPlatformUI().showError("Panel opening error", "Can't create panel " + this.panel.getLabel(), (Throwable)e2);
                    return;
                }
                SQLEditor.this.extraPresentationManager.panels.put(this.panel, panelInstance);
                CTabItem tabItem = new CTabItem(SQLEditor.this.resultTabs, 64);
                tabItem.setControl(panelControl);
                tabItem.setText(this.panel.getLabel());
                tabItem.setToolTipText(this.panel.getDescription());
                tabItem.setImage(DBeaverIcons.getImage((DBPImage)this.panel.getIcon()));
                tabItem.setData((Object)panelInstance);
                tabItem.addDisposeListener(e -> {
                    this.setChecked(false);
                    panelControl.dispose();
                    SQLEditor.this.extraPresentationManager.panels.remove((Object)this.panel);
                    SQLEditor.this.extraPresentationManager.activePresentationPanel = null;
                    SQLEditor.this.resultTabDisposeListener.widgetDisposed(e);
                });
                SQLEditor.this.extraPresentationManager.activePresentationPanel = panelInstance;
                SQLEditor.this.setResultTabSelection(tabItem);
            } else {
                for (CTabItem tabItem : SQLEditor.this.resultTabs.getItems()) {
                    if (tabItem.getData() != panelInstance) continue;
                    SQLEditor.this.setResultTabSelection(tabItem);
                    break;
                }
            }
            if (!SQLEditor.this.isHideQueryText() && SQLEditor.this.resultsSash.getMaximizedControl() != null) {
                UIUtils.asyncExec(() -> SQLEditor.this.resultsSash.setMaximizedControl(null));
            }
        }
    }

    private class OutputLogWriter
    implements DBCOutputWriter {
        private OutputLogWriter() {
        }

        public void println(@Nullable DBCOutputSeverity severity, @Nullable String message) {
            UIUtils.syncExec(() -> {
                if (!SQLEditor.this.outputViewer.isDisposed()) {
                    SQLEditor.this.outputViewer.println(severity, message);
                    SQLEditor.this.outputViewer.getViewer().scrollToEnd();
                    if (!SQLEditor.this.outputViewer.isVisible()) {
                        SQLEditor.this.updateOutputViewerIcon(true);
                    }
                }
            });
        }

        public void flush() {
            SQLEditor.this.outputViewer.flush();
        }
    }

    private class SaveJob
    extends AbstractJob {
        private transient Boolean success;

        SaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' data changes...");
            this.success = null;
            this.setUser(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            monitor.beginTask("Save query processors", SQLEditor.this.queryProcessors.size());
            try {
                for (QueryProcessor queryProcessor : SQLEditor.this.queryProcessors) {
                    for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                        ResultSetViewer rsv = resultsProvider.getResultSetController();
                        if (rsv == null || !rsv.isDirty()) continue;
                        rsv.doSave(monitor);
                    }
                    monitor.worked(1);
                }
                this.success = true;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable e) {
                this.success = false;
                SQLEditorBase.log.error((Object)e);
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (this.success == null) {
                    this.success = true;
                }
                monitor.done();
            }
        }
    }

    private class ScriptAutoSaveJob
    extends AbstractJob {
        ScriptAutoSaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' script");
            this.setSystem(true);
        }

        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            if (EditorUtils.isInAutoSaveJob()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Auto-save SQL script", 1);
            try {
                UIUtils.asyncExec(() -> SQLEditor.this.doTextEditorSave(monitor));
            }
            catch (Throwable e) {
                SQLEditorBase.log.debug((Object)e);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private static class ServerOutputInfo {
        private final DBCServerOutputReader outputReader;
        private final DBCExecutionContext executionContext;
        private final DBCExecutionResult result;

        ServerOutputInfo(DBCServerOutputReader outputReader, DBCExecutionContext executionContext, DBCExecutionResult result) {
            this.outputReader = outputReader;
            this.executionContext = executionContext;
            this.result = result;
        }
    }

    private class OutputAutoShowToggleAction
    extends Action {
        OutputAutoShowToggleAction() {
            super(SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view, 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            this.setChecked(SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.outputPanel.autoShow"));
        }

        public void run() {
            SQLEditor.this.getActivePreferenceStore().setValue("SQLEditor.outputPanel.autoShow", this.isChecked());
            try {
                SQLEditor.this.getActivePreferenceStore().save();
            }
            catch (IOException e) {
                SQLEditorBase.log.error((Object)e);
            }
        }
    }

    private class ConnectVisualizer
    extends UIJob {
        private boolean stopped;
        private int tickCount;
        private Cursor oldCursor;

        protected ConnectVisualizer() {
            super("Connect visualizer");
            this.stopped = false;
            this.setSystem(true);
            this.setUser(false);
            StyledText editorControl = SQLEditor.this.getEditorControl();
            if (editorControl != null) {
                this.oldCursor = editorControl.getCursor();
                editorControl.setCursor(editorControl.getDisplay().getSystemCursor(3));
            }
            this.schedule();
        }

        public void stop() {
            this.stopped = true;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ++this.tickCount;
            StyledText editorControl = SQLEditor.this.getEditorControl();
            if (editorControl == null || editorControl.isDisposed()) {
                this.stopped = true;
            }
            if (!this.stopped) {
                SQLEditor.this.setTitleImage(DBeaverIcons.getImage((DBPImage)((DBPImage)UIIcon.LOADING.get(this.tickCount % UIIcon.LOADING.size()))));
                this.schedule(100L);
            } else {
                if (this.oldCursor != null && editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setCursor(this.oldCursor);
                }
                SQLEditor.this.refreshEditorIconAndTitle();
            }
            return Status.OK_STATUS;
        }
    }

    public static class SQLEditorQueryListener
    implements SQLQueryListener {
        private final QueryProcessor queryProcessor;
        private boolean scriptMode;
        private long lastUIUpdateTime;
        private final ITextSelection originalSelection;
        private int topOffset;
        private int visibleLength;
        private final boolean closeTabOnError;
        private SQLQueryListener extListener;

        SQLEditorQueryListener(QueryProcessor queryProcessor, boolean closeTabOnError) {
            this.originalSelection = (ITextSelection)queryProcessor.getOwner().getSelectionProvider().getSelection();
            this.queryProcessor = queryProcessor;
            this.closeTabOnError = closeTabOnError;
        }

        @NotNull
        private SQLEditor getOwner() {
            return this.queryProcessor.getOwner();
        }

        public void setExtListener(SQLQueryListener extListener) {
            this.extListener = extListener;
        }

        public void onStartScript() {
            try {
                this.lastUIUpdateTime = -1L;
                this.scriptMode = true;
                UIUtils.asyncExec(() -> {
                    SQLEditor owner = this.queryProcessor.getOwner();
                    if (owner.isDisposed()) {
                        return;
                    }
                    if (owner.getActivePreferenceStore().getBoolean("SQLEditor.maxEditorOnScriptExecute") && owner.isResultSetAutoFocusEnabled && !owner.isHideQueryText()) {
                        owner.resultsSash.setMaximizedControl((Control)owner.sqlEditorPanel);
                    }
                    owner.clearProblems(null);
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartScript();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStartQuery(DBCSession session, SQLQuery query) {
            try {
                boolean isInExecute;
                SQLEditor owner = this.queryProcessor.getOwner();
                boolean bl = isInExecute = owner.getTotalQueryRunning() > 0;
                if (!isInExecute) {
                    UIUtils.asyncExec(() -> {
                        owner.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT_EXECUTE));
                        owner.updateDirtyFlag();
                        if (!this.scriptMode) {
                            owner.clearProblems(query);
                        }
                    });
                }
                this.queryProcessor.getCurJobRunning().incrementAndGet();
                List<SQLQuery> list = owner.runningQueries;
                synchronized (list) {
                    owner.runningQueries.add(query);
                }
                if (this.lastUIUpdateTime < 0L || System.currentTimeMillis() - this.lastUIUpdateTime > 100L) {
                    UIUtils.asyncExec(() -> {
                        TextViewer textViewer = owner.getTextViewer();
                        if (textViewer != null) {
                            this.topOffset = textViewer.getTopIndexStartOffset();
                            this.visibleLength = textViewer.getBottomIndexEndOffset() - this.topOffset;
                        }
                    });
                    if (this.scriptMode) {
                        owner.showStatementInEditor(query, false);
                    }
                    this.lastUIUpdateTime = System.currentTimeMillis();
                }
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartQuery(session, query);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
            try {
                SQLEditor owner = this.getOwner();
                List<SQLQuery> list = owner.runningQueries;
                synchronized (list) {
                    owner.runningQueries.remove(result.getStatement());
                }
                this.queryProcessor.getCurJobRunning().updateAndGet(i -> i > 0 ? i - 1 : i);
                if (owner.getTotalQueryRunning() <= 0) {
                    UIUtils.asyncExec(() -> {
                        if (owner.isDisposed()) {
                            return;
                        }
                        owner.setTitleImage(owner.editorImage);
                        owner.updateDirtyFlag();
                    });
                }
                if (owner.isDisposed()) {
                    return;
                }
                UIUtils.runUIJob((String)"Process SQL query result", monitor -> {
                    if (owner.isDisposed()) {
                        return;
                    }
                    this.processQueryResult(monitor, result, statistics);
                    owner.updateDirtyFlag();
                    owner.refreshActions();
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndQuery(session, result, statistics);
                }
            }
        }

        private void refreshContextDefaults(DBCSession session) {
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext executionContext = this.getOwner().getExecutionContext();
            if (executionContext != null && session != null && this.getOwner().getActivePreferenceStore().getBoolean("SQLEditor.refreshDefaultsAfterExecute") && (contextDefaults = executionContext.getContextDefaults()) != null) {
                try {
                    DBUtils.refreshContextDefaultsAndReflect((DBRProgressMonitor)session.getProgressMonitor(), (DBCExecutionContextDefaults)contextDefaults, (DBCExecutionContext)executionContext);
                }
                catch (Exception e) {
                    SQLEditorBase.log.debug((Object)"Error refreshing context defaults", (Throwable)e);
                }
            }
        }

        private void processQueryResult(DBRProgressMonitor monitor, SQLQueryResult result, DBCStatistics statistics) {
            UIServiceSystemAgent serviceSystemAgent;
            CTabItem tabItem;
            SQLEditor owner = this.getOwner();
            if (!this.scriptMode) {
                owner.runPostExecuteActions(result);
            }
            SQLQuery query = result.getStatement();
            Throwable error = result.getError();
            ISelectionProvider selectionProvider = owner.getSelectionProvider();
            if (selectionProvider == null) {
                return;
            }
            if (error != null) {
                SQLQuery sqlQuery;
                Iterator<QueryResultsContainer> originalQuery;
                owner.setStatus(GeneralUtils.getFirstMessage((Throwable)error), DBPMessageType.ERROR);
                SQLScriptElement sQLScriptElement = owner.curResultsContainer.getQuery();
                Object object = originalQuery = sQLScriptElement instanceof SQLQuery ? (sqlQuery = (SQLQuery)sQLScriptElement) : null;
                if (!owner.visualizeQueryErrors(monitor, query, error, (SQLQuery)originalQuery)) {
                    int errorQueryOffset = query.getOffset();
                    int errorQueryLength = query.getLength();
                    if (errorQueryOffset >= 0 && errorQueryLength > 0) {
                        if (!owner.addProblem(GeneralUtils.getFirstMessage((Throwable)error), new Position(errorQueryOffset, errorQueryLength))) {
                            if (this.scriptMode) {
                                selectionProvider.setSelection((ISelection)new TextSelection(errorQueryOffset, errorQueryLength));
                            } else {
                                selectionProvider.setSelection((ISelection)this.originalSelection);
                            }
                        }
                        owner.setLastQueryErrorPosition(errorQueryOffset);
                    }
                }
            }
            owner.notifyOnQueryResultListeners(owner.curResultsContainer, result);
            for (QueryResultsContainer cr : this.queryProcessor.resultContainers) {
                cr.viewer.updateFiltersText(false);
            }
            if (!result.hasError() && !this.queryProcessor.resultContainers.isEmpty()) {
                if (owner.activeResultsTab != null && !owner.activeResultsTab.isDisposed()) {
                    owner.setResultTabSelection(owner.activeResultsTab);
                } else {
                    owner.setResultTabSelection(this.queryProcessor.resultContainers.getFirst().getResultsTab());
                }
            }
            if (this.scriptMode || !this.queryProcessor.getResultContainers().isEmpty()) {
                int queryIndex = owner.queryProcessors.indexOf(this.queryProcessor);
                int resultsIndex = 0;
                for (QueryResultsContainer results : this.queryProcessor.resultContainers) {
                    if (results.getQuery() != query) {
                        results.handleExecuteResult((DBCExecutionResult)result);
                        if (!owner.getActivePreferenceStore().getBoolean("SQLEditor.setSelectionToStatisticsTab") || query.getType() == SQLQueryType.SELECT) continue;
                        owner.setResultTabSelection(results.getResultsTab());
                        continue;
                    }
                    if (resultsIndex < result.getExecuteResults().size()) {
                        ResultSetViewer resultSetViewer;
                        SQLQueryResult.ExecuteResult executeResult = result.getExecuteResults(resultsIndex, true);
                        String resultSetName = results.getTabName();
                        if (CommonUtils.isEmpty((String)resultSetName)) {
                            resultSetName = owner.getResultsTabName(results.resultSetNumber, queryIndex, executeResult.getResultSetName());
                            results.updateResultsName(resultSetName, null);
                            owner.setResultTabSelection(results.getResultsTab());
                        }
                        if ((resultSetViewer = results.getResultSetController()) != null) {
                            resultSetViewer.getModel().setStatistics(statistics);
                        }
                        results.handleExecuteResult((DBCExecutionResult)result);
                    }
                    ++resultsIndex;
                }
                if (!owner.getActivePreferenceStore().getBoolean("SQLEditor.maxEditorOnScriptExecute") && owner.resultsSash.getMaximizedControl() == owner.sqlEditorPanel) {
                    owner.toggleResultPanel(false, false);
                }
            } else {
                owner.dumpQueryServerOutput((DBCExecutionResult)result);
            }
            if (this.closeTabOnError && error != null && (tabItem = this.queryProcessor.getFirstResults().getResultsTab()) != null && tabItem.getShowClose()) {
                tabItem.dispose();
            }
            if (owner.getDataSourceContainer() != null && !this.scriptMode && owner.getActivePreferenceStore().getBoolean("SQLEditor.beepOnQueryEnd")) {
                Display.getCurrent().beep();
            }
            if ((serviceSystemAgent = (UIServiceSystemAgent)DBWorkbench.getService(UIServiceSystemAgent.class)) != null && result.getQueryTime() > serviceSystemAgent.getLongOperationTimeout() * 1000L) {
                serviceSystemAgent.notifyAgent("Query completed [" + owner.getEditorInput().getName() + "]" + GeneralUtils.getDefaultLineSeparator() + CommonUtils.truncateString((String)query.getText(), (int)200), !result.hasError() ? 1 : 4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            try {
                SQLEditor owner = this.getOwner();
                if (owner.isDisposed()) {
                    return;
                }
                owner.runPostExecuteActions(null);
                UIUtils.asyncExec(() -> {
                    QueryResultsContainer results;
                    ResultSetViewer viewer;
                    if (owner.isDisposed()) {
                        return;
                    }
                    if (!owner.isHideQueryText()) {
                        owner.resultsSash.setMaximizedControl(null);
                        if (!hasErrors) {
                            owner.getSelectionProvider().setSelection((ISelection)this.originalSelection);
                        }
                    }
                    if ((viewer = (results = this.queryProcessor.getFirstResults()).getResultSetController()) != null) {
                        viewer.getModel().setStatistics(statistics);
                        viewer.updateStatusMessage();
                    }
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndScript(statistics, hasErrors);
                }
            }
        }

        public void onEndSqlJob(DBCSession session, SqlJobResult result) {
            if (result == SqlJobResult.SUCCESS || result == SqlJobResult.PARTIAL_SUCCESS) {
                this.refreshContextDefaults(session);
            }
            if (this.extListener != null) {
                this.extListener.onEndSqlJob(session, result);
            }
        }

        public void redrawEditor() {
            this.getOwner().showResultsPanel(false);
        }
    }

    public static class ResultSetOrientationMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (!(activeEditor instanceof SQLEditorBase)) {
                return new IContributionItem[0];
            }
            final DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            String curPresentation = preferenceStore.getString("SQLEditor.resultSet.orientation");
            ResultSetOrientation[] orientations = ResultSetOrientation.values();
            ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>(orientations.length);
            for (final ResultSetOrientation orientation : orientations) {
                Action action = new Action(this, orientation.getLabel(), 8){

                    public void run() {
                        preferenceStore.setValue("SQLEditor.resultSet.orientation", orientation.name());
                        PrefUtils.savePreferenceStore((DBPPreferenceStore)preferenceStore);
                    }
                };
                action.setDescription(orientation.getDescription());
                if (!orientation.isSupported()) {
                    action.setEnabled(false);
                }
                if (orientation.name().equals(curPresentation)) {
                    action.setChecked(true);
                }
                items.add(new ActionContributionItem((IAction)action));
            }
            return items.toArray(new IContributionItem[0]);
        }
    }
}

