/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.databinding;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPageService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.databinding.ListeningValue;

public class ActivePageProperty<S extends IPageService>
extends ValueProperty<S, IWorkbenchPage> {
    public Object getValueType() {
        return IWorkbenchPage.class;
    }

    protected IWorkbenchPage doGetValue(S source) {
        return source.getActivePage();
    }

    protected void doSetValue(S source, IWorkbenchPage value) {
        throw new UnsupportedOperationException();
    }

    public IObservableValue<IWorkbenchPage> observe(Realm realm, final S source) {
        return new ListeningValue<IWorkbenchPage>(realm){
            private final IPageListener listener;
            {
                super($anonymous0);
                this.listener = new IPageListener(){

                    @Override
                    public void pageActivated(IWorkbenchPage page) {
                        this.protectedSetValue(page);
                    }

                    @Override
                    public void pageClosed(IWorkbenchPage page) {
                        if (page == this.doGetValue()) {
                            this.protectedSetValue(null);
                        }
                    }

                    @Override
                    public void pageOpened(IWorkbenchPage page) {
                    }
                };
            }

            @Override
            protected void startListening() {
                source.addPageListener(this.listener);
            }

            @Override
            protected void stopListening() {
                source.removePageListener(this.listener);
            }

            @Override
            protected IWorkbenchPage calculate() {
                return (IWorkbenchPage)ActivePageProperty.this.getValue(source);
            }

            public Object getValueType() {
                return ActivePageProperty.this.getValueType();
            }
        };
    }
}

