/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;

public class BinaryTextFinder {
    public static final int MAP_SIZE = 65536;
    public static final int MAX_SEQUENCE_SIZE = 2048;
    private long bufferPosition = -1L;
    private ByteBuffer byteBuffer = null;
    private int currentPartFound = -1;
    private boolean currentPartFoundIsUnicode = false;
    private long currentPosition = 0L;
    private byte[] byteFindSequence = null;
    private boolean caseSensitive = true;
    private BinaryContent content = null;
    private boolean directionForward = true;
    private CharSequence literal = null;
    private int literalByteLength = -1;
    private Pattern pattern = null;
    private boolean stopSearching = false;

    public BinaryTextFinder(CharSequence literal, BinaryContent aContent) {
        this.literal = literal;
        this.initSearchUnicodeAscii();
        this.content = aContent;
        this.bufferPosition = 0L;
        this.currentPosition = 0L;
    }

    public BinaryTextFinder(byte[] sequence, BinaryContent aContent) {
        this.initSearchHex(sequence);
        this.content = aContent;
        this.bufferPosition = 0L;
        this.currentPosition = 0L;
    }

    void findAllMatches() throws IOException {
        this.currentPartFound = this.findHexAsciiMatchInPart();
        int currentPartFoundUnicode = this.findUnicodeMatchInPart();
        this.currentPartFoundIsUnicode = false;
        if (currentPartFoundUnicode >= 0 && (this.currentPartFound < 0 || this.directionForward && this.currentPartFound > currentPartFoundUnicode || !this.directionForward && this.currentPartFound < currentPartFoundUnicode)) {
            this.currentPartFound = currentPartFoundUnicode;
            this.currentPartFoundIsUnicode = true;
        }
    }

    private int findHexAsciiMatchInPart() throws IOException {
        if (this.byteFindSequence == null) {
            return -1;
        }
        int start = 0;
        int inclusiveEnd = this.byteBuffer.limit() - this.byteFindSequence.length;
        if (!this.directionForward) {
            start = inclusiveEnd;
            inclusiveEnd = 0;
        }
        for (int i = start; this.directionForward && i <= inclusiveEnd || !this.directionForward && i >= inclusiveEnd; i += this.directionForward ? 1 : -1) {
            boolean matchesSoFar = true;
            for (int j = 0; j < this.byteFindSequence.length && matchesSoFar; ++j) {
                byte matcher;
                byte existing = this.byteBuffer.get(i + j);
                if (existing == (matcher = this.byteFindSequence[j]) || !this.caseSensitive && existing >= 65 && existing <= 122 && matcher >= 65 && matcher <= 122 && (existing - matcher == 32 || matcher - existing == 32)) continue;
                matchesSoFar = false;
            }
            if (!matchesSoFar) continue;
            return i;
        }
        return -1;
    }

    private int findUnicodeMatchInPart() throws IOException {
        if (this.pattern == null) {
            return -1;
        }
        int result = Integer.MAX_VALUE;
        if (!this.directionForward) {
            result = -1;
        }
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Matcher matcher = this.pattern.matcher(this.byteBuffer.asCharBuffer());
        for (int encoding = 0; encoding < 4; ++encoding) {
            while (matcher.find()) {
                int index = matcher.start() * 2 + (encoding >= 2 ? 1 : 0);
                if (this.directionForward && result > index || !this.directionForward && result < index) {
                    result = index;
                }
                if (!this.directionForward) continue;
                break;
            }
            if (encoding == 0) {
                this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else if (encoding == 1 && this.byteBuffer.limit() > 0) {
                this.byteBuffer.position(1);
            } else if (encoding == 2) {
                this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            matcher.reset(this.byteBuffer.asCharBuffer());
        }
        if (result == Integer.MAX_VALUE) {
            result = -1;
        }
        return result;
    }

    long getContentLength() {
        if (this.content == null) {
            return 0L;
        }
        return this.content.length();
    }

    public Number[] getNextMatch() throws IOException {
        this.stopSearching = false;
        this.populatePart();
        this.findAllMatches();
        while (this.currentPartFound < 0) {
            if (this.nextPart() == null || this.stopSearching) {
                this.stopSearching = false;
                return null;
            }
            this.findAllMatches();
        }
        long resultPosition = this.bufferPosition + (long)this.currentPartFound;
        int length = this.currentPartFoundIsUnicode ? this.literalByteLength : this.byteFindSequence.length;
        this.setNewStart(resultPosition + (long)(this.directionForward ? 1 : length - 1));
        return new Number[]{resultPosition, length};
    }

    void initSearchHex(byte[] sequence) {
        this.byteFindSequence = sequence;
        if (sequence.length > 2048) {
            this.byteFindSequence = new byte[2048];
            System.arraycopy(sequence, 0, this.byteFindSequence, 0, 2048);
        }
        this.literalByteLength = this.byteFindSequence.length;
    }

    public long getSearchPosition() {
        return this.bufferPosition;
    }

    void initSearchUnicodeAscii() {
        StringBuilder regex = new StringBuilder("\\Q");
        if (this.literal.length() * 2 > 2048) {
            this.literal = this.literal.subSequence(0, 1024);
        }
        this.literalByteLength = this.literal.length() * 2;
        boolean isAsciiCompatible = true;
        byte[] tmpBytes = new byte[this.literal.length()];
        int previous = 0;
        for (int i = 0; i < this.literal.length(); ++i) {
            char aChar = this.literal.charAt(i);
            regex.append(aChar);
            if (previous == 92 && aChar == 'E') {
                regex.append("\\\\E\\Q");
            }
            previous = aChar;
            tmpBytes[i] = (byte)aChar;
            if (aChar <= '\u00ff') continue;
            isAsciiCompatible = false;
        }
        regex.append("\\E");
        int ignoreCaseFlags = 0;
        if (!this.caseSensitive) {
            ignoreCaseFlags = 66;
        }
        this.pattern = Pattern.compile(regex.toString(), ignoreCaseFlags);
        if (isAsciiCompatible) {
            this.byteFindSequence = tmpBytes;
        }
    }

    ByteBuffer nextPart() throws IOException {
        long newPos = this.bufferPosition + (long)this.byteBuffer.limit() - (long)this.literalByteLength + 1L;
        if (!this.directionForward) {
            newPos = this.bufferPosition - 65536L + (long)this.literalByteLength - 1L;
        }
        if (newPos < 0L) {
            newPos = 0L;
        }
        int size = (int)Math.min(65536L, this.getContentLength() - newPos);
        if (!this.directionForward) {
            size = (int)(this.bufferPosition + (long)this.literalByteLength - 1L - newPos);
        }
        if (size < this.literalByteLength) {
            return null;
        }
        this.bufferPosition = newPos;
        this.populatePart(size);
        return this.byteBuffer;
    }

    void populatePart() throws IOException {
        int size = 65536;
        if (!this.directionForward) {
            size = (int)Math.min(65536L, this.currentPosition);
        }
        this.populatePart(size);
    }

    void populatePart(int size) throws IOException {
        if (this.content == null) {
            return;
        }
        this.byteBuffer = null;
        this.byteBuffer = ByteBuffer.allocate(65536);
        this.byteBuffer.limit(size);
        this.byteBuffer.position(0);
        this.content.get(this.byteBuffer, this.bufferPosition);
        this.byteBuffer.limit(this.byteBuffer.position());
        this.byteBuffer.position(0);
    }

    public void setCaseSensitive(boolean beSensitive) {
        if (this.caseSensitive == beSensitive) {
            return;
        }
        this.caseSensitive = beSensitive;
        if (this.literal != null) {
            this.initSearchUnicodeAscii();
        }
    }

    public void setDirectionForward(boolean goForward) {
        this.directionForward = goForward;
    }

    public void setNewStart(long startPoint) {
        if (startPoint < 0L || startPoint > this.getContentLength()) {
            return;
        }
        this.currentPosition = startPoint;
        this.bufferPosition = startPoint;
        if (!this.directionForward) {
            this.bufferPosition = startPoint - 65536L;
        }
        if (this.bufferPosition < 0L) {
            this.bufferPosition = 0L;
        }
    }

    public void stopSearching() {
        this.stopSearching = true;
    }
}

