/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLGeneratorSimpleJoin
extends SQLGenerator<DBSEntity> {
    @Override
    public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
        StringBuilder sql = new StringBuilder(100);
        SQLDialect sqlDialect = ((DBSEntity)this.objects.get(0)).getDataSource().getSQLDialect();
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            int i;
            sql.append("SELECT ");
            for (i = 0; i < this.objects.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                String alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)this.objects.get(i)), s -> sqlDialect.getKeywordType(s) != null || aliases.contains(s));
                sql.append(alias).append(".*");
                aliases.add(alias);
            }
            sql.append(this.getLineSeparator()).append("FROM ");
            for (i = 0; i < this.objects.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(this.getEntityName((DBSEntity)this.objects.get(i))).append(" ").append((String)aliases.get(i));
            }
            sql.append(this.getLineSeparator()).append("WHERE ");
            boolean hasCond = false;
            for (int i2 = 1; i2 < this.objects.size(); ++i2) {
                boolean foundJoin = false;
                for (int k = 0; k < i2; ++k) {
                    String tableJoin = SQLUtils.generateTableJoin((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)this.objects.get(k)), (String)((String)aliases.get(k)), (DBSEntity)((DBSEntity)this.objects.get(i2)), (String)((String)aliases.get(i2)));
                    if (tableJoin == null) continue;
                    sql.append(this.getLineSeparator()).append("\t");
                    if (hasCond) {
                        sql.append("AND ");
                    }
                    sql.append(tableJoin);
                    hasCond = true;
                    foundJoin = true;
                    break;
                }
                if (foundJoin) continue;
                sql.append("\n-- Can't determine condition to join table ").append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)this.objects.get(i2))));
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.result = sql.toString();
    }

    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) {
    }
}

