/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gbase8s.model.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.gbase8s.GBase8sUtils;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sCatalog;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sCheckConstraint;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sDataTypeCache;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sProcedure;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sSchema;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sSynonym;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTable;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTableColumn;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTableTrigger;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class GBase8sMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(GBase8sMetaModel.class);
    private static final String[] VALID_TABLE_TYPES = new String[]{"T", "V"};
    private static final String[] VALID_SYNONYM_TYPES = new String[]{"S"};

    public JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> createDataTypeCache(@NotNull GenericStructContainer container) {
        return new GBase8sDataTypeCache(container);
    }

    public GenericCatalog createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new GBase8sCatalog(dataSource, catalogName);
    }

    @NotNull
    public GenericProcedure createProcedureImpl(@NotNull GenericStructContainer container, @NotNull String procedureName, String specificName, String remarks, @NotNull DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new GBase8sProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new GBase8sSchema(dataSource, catalog, schemaName);
    }

    public GenericSynonym createSynonymImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        return new GBase8sSynonym(container, name, description, dbResult);
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new GBase8sTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    @NotNull
    public GenericTableBase createTableOrViewImpl(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new GBase8sTable(container, tableName, tableType, dbResult);
    }

    @NotNull
    public GenericTableTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull GenericTableBase genericTableBase, String triggerName, @NotNull JDBCResultSet resultSet) {
        if (CommonUtils.isEmpty((String)triggerName)) {
            triggerName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TRIGGER_NAME");
        }
        if (triggerName == null) {
            return null;
        }
        triggerName = triggerName.trim();
        return new GBase8sTableTrigger(genericTableBase, triggerName, resultSet);
    }

    public String getProcedureDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericProcedure sourceObject) throws DBException {
        return GBase8sUtils.getProcedureSource(monitor, sourceObject);
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        String tableDDL = super.getTableDDL(monitor, sourceObject, options);
        return tableDDL + GBase8sUtils.getTriggerDDL(monitor, sourceObject);
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return GBase8sUtils.getTriggerDDL(monitor, trigger);
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return GBase8sUtils.getViewDDL(monitor, (GenericTableBase)sourceObject);
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException, DBException {
        String tableName = forParent == null ? owner.getDataSource().getAllObjectsPattern() : JDBCUtils.escapeWildCards((JDBCSession)session, (String)forParent.getName());
        String catalog = owner.getCatalog() == null ? null : owner.getCatalog().getName();
        String schema = owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName());
        boolean isOracleMode = GBase8sUtils.isOracleSqlMode(owner.getDataSource().getContainer());
        String ownerPattern = "%s%s".formatted(isOracleMode ? schema : catalog, isOracleMode ? "." : ":");
        String sql = "SELECT\n    t.tabname AS TABLE_NAME,\n    c.constrname AS CONSTRAINT_NAME,\n    c.constrtype AS CONSTRAINT_TYPE,\n    c.idxname AS INDEX_NAME,\n    c.constrname AS PK_NAME,\n    col.colname AS COLUMN_NAME,\n    trim(ck.checktext) AS CHECK_TEXT,\n    CASE WHEN c.constrtype != 'C' THEN ROW_NUMBER() OVER (PARTITION BY c.tabid, c.constrname ORDER BY col.colno) ELSE NULL END AS KEY_SEQ\nFROM (\n    SELECT constrid, constrname, tabid, constrtype, idxname\n    FROM %ssysconstraints\n    WHERE constrtype IN ('U', 'P', 'C')\n) c\nLEFT JOIN %ssystables t ON c.tabid = t.tabid\nLEFT JOIN (\n    SELECT constrid, checktext\n    FROM %ssyschecks\n    WHERE type IN ('T') AND seqno = 0\n) ck ON c.constrid = ck.constrid\nLEFT JOIN %ssyscoldepend cd ON c.constrid = cd.constrid\nLEFT JOIN %ssysindexes i ON c.idxname = i.idxname\nLEFT JOIN %ssyscolumns col ON c.tabid = col.tabid\nWHERE\n    t.tabname = ?\n    AND (\n        col.colno IN (\n            i.part1, i.part2, i.part3, i.part4, i.part5, i.part6,\n            i.part7, i.part8, i.part9, i.part10, i.part11, i.part12,\n            i.part13, i.part14, i.part15, i.part16\n        )\n        OR (c.constrtype = 'C' AND col.colno = cd.colno)\n    )\nORDER BY col.tabid, c.constrid, KEY_SEQ;\n".formatted(ownerPattern, ownerPattern, ownerPattern, ownerPattern, ownerPattern, ownerPattern);
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, tableName);
        return dbStat;
    }

    @NotNull
    public GBase8sUniqueKey createConstraintImpl(@NotNull GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        if (dbResult == null || !constraintType.isUnique()) {
            String checkText = dbResult != null ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHECK_TEXT") : null;
            return new GBase8sCheckConstraint(table, constraintName, null, constraintType, checkText, persisted);
        }
        return new GBase8sUniqueKey(table, constraintName, null, constraintType, persisted);
    }

    public DBSEntityConstraintType getUniqueConstraintType(@NotNull JDBCResultSet dbResult) throws DBException, SQLException {
        String constraintType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
        if (constraintType == null) {
            log.warn((Object)"Can't get column 'CONSTRAINT_TYPE': No such column name");
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        switch (constraintType) {
            case "U": {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            case "C": {
                return DBSEntityConstraintType.CHECK;
            }
        }
        return DBSEntityConstraintType.PRIMARY_KEY;
    }

    public boolean supportsUniqueKeys() {
        return true;
    }

    public boolean supportsCheckConstraints() {
        return true;
    }

    public void loadProcedures(@NotNull DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        block23: {
            LinkedHashMap funcMap = new LinkedHashMap();
            JDBCPreparedStatement dbState = null;
            JDBCResultSet dbResult = null;
            GenericDataSource dataSource = container.getDataSource();
            GenericMetaObject procObject = dataSource.getMetaObject("procedure");
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load procedures");){
                if (!this.hasProcedureSupport()) break block23;
                String sql = "SELECT procid, procname, isproc, specificname, type, procflags, paramtypes::LVARCHAR AS columntypenames, mode\nFROM sysprocedures\n";
                dbState = session.prepareStatement(sql);
                dbResult = dbState.executeQuery();
                while (dbResult.next()) {
                    GenericProcedure function;
                    DBSProcedureType procedureType;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String procedureName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"procname");
                    String specificName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"specificname");
                    String isProc = GenericUtils.safeGetString((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"isproc");
                    String procType = GenericUtils.safeGetString((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"type");
                    if (!"0".equalsIgnoreCase(procType) || container.hasProcedure(procedureName)) continue;
                    switch (isProc) {
                        case "t": {
                            DBSProcedureType dBSProcedureType = DBSProcedureType.PROCEDURE;
                            break;
                        }
                        case "f": {
                            DBSProcedureType dBSProcedureType;
                            if (this.hasFunctionSupport()) {
                                dBSProcedureType = DBSProcedureType.FUNCTION;
                                break;
                            }
                            dBSProcedureType = DBSProcedureType.UNKNOWN;
                            break;
                        }
                        case "u": {
                            DBSProcedureType dBSProcedureType = DBSProcedureType.PROCEDURE;
                            break;
                        }
                        default: {
                            DBSProcedureType dBSProcedureType = procedureType = DBSProcedureType.UNKNOWN;
                        }
                    }
                    if (CommonUtils.isEmpty((String)specificName)) {
                        specificName = procedureName;
                    }
                    if ((function = (GenericProcedure)funcMap.get(procedureName)) != null && !this.supportsEqualFunctionsAndProceduresNames()) {
                        log.debug((Object)("Broken driver [" + session.getDataSource().getContainer().getDriver().getName() + "] - returns the same list for getProcedures and getFunctons"));
                        break;
                    }
                    GenericProcedure procedure = this.createProcedureImpl((GenericStructContainer)container, procedureName, specificName, null, procedureType, (GenericFunctionResultType)(DBSProcedureType.FUNCTION.equals((Object)procedureType) ? GenericFunctionResultType.TABLE : null));
                    container.addProcedure(procedure);
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)dataSource);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<GBase8sTableTrigger> loadTriggers(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        assert (table != null);
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
            ArrayList<GBase8sTableTrigger> arrayList;
            block23: {
                String query = "SELECT T1.trigname FROM systriggers AS T1, systables AS T2 WHERE T2.tabid = T1.tabid AND T2.tabname = ?";
                JDBCPreparedStatement dbStat = session.prepareStatement(query);
                try {
                    dbStat.setString(1, table.getName());
                    ArrayList<GBase8sTableTrigger> result = new ArrayList<GBase8sTableTrigger>();
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            if (name == null) continue;
                            result.add(new GBase8sTableTrigger(table, name.trim(), dbResult));
                        }
                    }
                    arrayList = result;
                    if (dbStat == null) break block23;
                }
                catch (Throwable throwable) {
                    if (dbStat != null) {
                        try {
                            dbStat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbStat.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public JDBCStatement prepareSynonymsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        return this.prepareTSObjectLoadStatement(session, container, null, "%", VALID_SYNONYM_TYPES);
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        return this.prepareTSObjectLoadStatement(session, owner, object, objectName, VALID_TABLE_TYPES);
    }

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        String tableName = forTable == null ? owner.getDataSource().getAllObjectsPattern() : JDBCUtils.escapeWildCards((JDBCSession)session, (String)forTable.getName());
        String catalog = owner.getCatalog() == null ? null : owner.getCatalog().getName();
        String schema = owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName());
        boolean isOracleMode = GBase8sUtils.isOracleSqlMode(owner.getDataSource().getContainer());
        String ownerPattern = "%s%s".formatted(isOracleMode ? schema : catalog, isOracleMode ? "." : ":");
        String sql = "SELECT\n    t.tabname::VARCHAR(128) AS TABLE_NAME,\n    c.colname::VARCHAR(128) AS COLUMN_NAME,\n    get_data_type(c.coltype, c.extended_id, 0)::SMALLINT AS DATA_TYPE,\n    0::SMALLINT AS SOURCE_DATA_TYPE,\n    schema_coltypename(c.coltype, c.extended_id)::VARCHAR(128) AS TYPE_NAME,\n    schema_precision(c.coltype, c.extended_id, c.collength)::INTEGER AS COLUMN_SIZE,\n    schema_numscale(c.coltype, c.collength)::INTEGER AS DECIMAL_DIGITS,\n    schema_numprecradix(c.coltype)::INTEGER AS NUM_PREC_RADIX,\n    CASE d.type\n        WHEN 'L' THEN get_default_value(c.coltype, c.extended_id, c.collength, d.default::lvarchar(256))::VARCHAR(254)\n        WHEN 'E' THEN read_defaultstr(c.tabid, c.colno, c.coltype, c.collength, c.extended_id)::VARCHAR(32731)\n        WHEN 'C' THEN 'current' || replace(get_colname(c.coltype, c.collength, c.extended_id, 1), schema_coltypename(c.coltype, c.extended_id), '')::VARCHAR(254)\n        WHEN 'S' THEN 'dbservername'::VARCHAR(254)\n        WHEN 'U' THEN 'user'::VARCHAR(254)\n        WHEN 'T' THEN 'today'::VARCHAR(254)\n        WHEN 'N' THEN 'null'::VARCHAR(10)\n        ELSE null::VARCHAR(254)\n    END AS COLUMN_DEF,\n    cc.comments AS REMARKS,\n    schema_isnullable(c.coltype)::INTEGER AS NULLABLE,\n    schema_nullable(c.coltype)::VARCHAR(3) AS ISNULLABLE,\n    c.coltype::INTEGER AS SQL_DATA_TYPE,\n    schema_datetype(c.coltype, c.collength)::INTEGER AS DB_DATA_TYPE,\n    schema_charlen(c.coltype, c.extended_id, c.collength)::INTEGER AS CHAR_OCTET_LENGTH,\n    c.colno::integer AS ORDINAL_POSITION,\n    schema_isautoincr(c.coltype)::VARCHAR(3) AS IS_AUTOINCREMENT,\n    null::VARCHAR(254) AS IS_GENERATEDCOLUMN,\n    c.extended_id::INTEGER AS EXTENDED_ID,\n    c.colattr::INTEGER AS COLATTR,\n    c.coltype\nFROM\n    %ssystables t,\n    OUTER %ssysdefaults d,\n    %ssyscolumns c,\n    OUTER %ssyscolcomms cc\nWHERE\n    t.tabid = c.tabid\n    AND d.tabid = t.tabid\n    AND c.colno = d.colno\n    AND t.tabid = cc.tabid\n    AND c.colno = cc.colno\n    AND t.tabname = ?\n".formatted(ownerPattern, ownerPattern, ownerPattern, ownerPattern);
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, tableName);
        return dbStat;
    }

    @NotNull
    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws SQLException {
        String query = "SELECT T1.trigname as TRIGGER_NAME, T1.*, T2.tabname AS OWNER\nFROM systriggers AS T1, systables AS T2\nWHERE T2.tabid = T1.tabid\n%s\n".formatted(table != null ? "AND T2.tabname = ?" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(query);
        if (table != null) {
            dbStat.setString(1, table.getName());
        }
        return dbStat;
    }

    JDBCStatement prepareTSObjectLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName, @Nullable String[] types) throws SQLException {
        String tableNamePattern;
        if (object == null && objectName == null) {
            DBSObjectFilter tableFilters = session.getDataSource().getContainer().getObjectFilter(GenericTable.class, (DBSObject)owner, false);
            if (tableFilters != null && tableFilters.hasSingleMask()) {
                tableNamePattern = tableFilters.getSingleMask();
                if (!CommonUtils.isEmpty((String)tableNamePattern)) {
                    tableNamePattern = SQLUtils.makeSQLLike((String)tableNamePattern);
                }
            } else {
                tableNamePattern = owner.getDataSource().getAllObjectsPattern();
            }
        } else {
            tableNamePattern = JDBCUtils.escapeWildCards((JDBCSession)session, (String)(object != null ? object.getName() : objectName));
        }
        String catalog = owner.getCatalog() == null ? null : owner.getCatalog().getName();
        String schema = owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName());
        boolean isOracleMode = GBase8sUtils.isOracleSqlMode(owner.getDataSource().getContainer());
        String ownerPattern = "%s%s".formatted(isOracleMode ? schema : catalog, isOracleMode ? "." : ":");
        String sql = "SELECT t.tabid, t.tabname AS TABLE_NAME, t.owner AS\n    %s,\n    CASE\n        WHEN t.tabtype = 'T' AND t.tabid <= (SELECT tabid FROM systables WHERE trim(tabname) = 'VERSION') THEN 'SYSTEM TABLE'\n        WHEN t.tabtype = 'V' AND t.tabid <= (SELECT tabid FROM systables WHERE trim(tabname) = 'VERSION') THEN 'SYSTEM VIEW'\n        WHEN t.tabtype = 'T' THEN 'TABLE'\n        WHEN t.tabtype = 'V' THEN 'VIEW'\n        ELSE 'SYNONYM'\n    END AS TABLE_TYPE,\n    c.comments AS REMARKS\nFROM %ssystables t\nLEFT JOIN %ssyscomms c ON t.tabid = c.tabid\nWHERE t.tabname LIKE ?\n%s\n".formatted(isOracleMode ? "TABLE_SCHEM" : "TABLE_CATALOG", ownerPattern, ownerPattern, types != null ? " AND t.tabtype IN (" + String.join((CharSequence)", ", Collections.nCopies(types.length, "?")) + ")" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        int paramIndex = 1;
        dbStat.setString(paramIndex++, tableNamePattern);
        if (types != null) {
            for (String type : types) {
                dbStat.setString(paramIndex++, type);
            }
        }
        return dbStat;
    }

    public boolean supportNestedForeignKeys() {
        return false;
    }

    public boolean supportsSynonyms(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public boolean hasFunctionSupport() {
        return true;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public boolean isTableColumnCommentEditable() {
        return true;
    }

    public boolean isTrimObjectNames() {
        return true;
    }
}

