/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Clob;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.ExternalContentStorage;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.data.storage.TemporaryContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentChars;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCContentCLOB
extends JDBCContentLOB
implements DBDContent {
    private static final Log log = Log.getLog(JDBCContentCLOB.class);
    private Clob clob;
    private Reader tmpReader;

    public JDBCContentCLOB(DBCExecutionContext executionContext, Clob clob) {
        super(executionContext);
        this.clob = clob;
    }

    @Override
    public long getLOBLength() throws DBCException {
        if (this.clob == null) {
            return 0L;
        }
        try {
            return this.clob.length();
        }
        catch (Throwable e) {
            throw new DBCException(e, this.executionContext);
        }
    }

    @NotNull
    public String getContentType() {
        return "text/plain";
    }

    public DBDContentStorage getContents(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.clob != null) {
            block20: {
                try {
                    Path tempFile;
                    long contentLength = this.getContentLength();
                    DBPPlatform platform = DBWorkbench.getPlatform();
                    if (contentLength < (long)platform.getPreferenceStore().getInt("content.memory.maxsize")) {
                        try {
                            String subString = this.clob.getSubString(1L, (int)contentLength);
                            this.storage = new JDBCContentChars(this.executionContext, subString);
                            break block20;
                        }
                        catch (Exception e) {
                            log.debug((Object)"Can't get CLOB as substring", (Throwable)e);
                            try {
                                this.storage = StringContentStorage.createFromReader((Reader)this.clob.getCharacterStream(), (long)contentLength);
                                break block20;
                            }
                            catch (IOException e1) {
                                throw new DBCException("IO error while reading content", (Throwable)e);
                            }
                            catch (Throwable e1) {
                                throw new DBCException((Throwable)e, this.executionContext);
                            }
                        }
                    }
                    try {
                        tempFile = ContentUtils.createTempContentFile((DBRProgressMonitor)monitor, (DBPPlatform)platform, (String)("clob" + this.clob.hashCode()));
                    }
                    catch (IOException e) {
                        throw new DBCException("Can't create temp file", (Throwable)e);
                    }
                    try (BufferedWriter os = Files.newBufferedWriter(tempFile, Charset.forName(this.getDefaultEncoding()), new OpenOption[0]);){
                        ContentUtils.copyStreams((Reader)this.clob.getCharacterStream(), (long)contentLength, (Writer)os, (DBRProgressMonitor)monitor);
                    }
                    catch (IOException e) {
                        ContentUtils.deleteTempFile((Path)tempFile);
                        throw new DBCException("IO error while copying content", (Throwable)e);
                    }
                    catch (Throwable e) {
                        ContentUtils.deleteTempFile((Path)tempFile);
                        throw new DBCException(e, this.executionContext);
                    }
                    this.storage = new TemporaryContentStorage(platform, tempFile, this.getDefaultEncoding(), true);
                }
                catch (DBCException e) {
                    this.handleContentReadingException(e);
                }
            }
            this.releaseClob();
        }
        return this.storage;
    }

    @Override
    public void release() {
        this.releaseTempStream();
        this.releaseClob();
        super.release();
    }

    private void releaseClob() {
        if (this.clob != null) {
            try {
                this.clob.free();
            }
            catch (Throwable e) {
                log.debug((Object)("Error freeing CLOB: " + e.getClass().getName() + ": " + e.getMessage()));
            }
            this.clob = null;
        }
    }

    private void releaseTempStream() {
        if (this.tmpReader != null) {
            ContentUtils.close((Closeable)this.tmpReader);
            this.tmpReader = null;
        }
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        block12: {
            try {
                if (this.storage != null) {
                    this.releaseTempStream();
                    this.tmpReader = this.storage.getContentReader();
                    try {
                        preparedStatement.setNCharacterStream(paramIndex, this.tmpReader);
                    }
                    catch (Throwable e) {
                        if (e instanceof SQLException && !JDBCUtils.isFeatureNotSupportedError((DBPDataSource)session.getDataSource(), e)) {
                            throw (SQLException)e;
                        }
                        long streamLength = ContentUtils.calculateContentLength((Reader)this.storage.getContentReader());
                        try {
                            preparedStatement.setCharacterStream(paramIndex, this.tmpReader, streamLength);
                            break block12;
                        }
                        catch (Throwable e1) {
                            if (e1 instanceof SQLException && !JDBCUtils.isFeatureNotSupportedError((DBPDataSource)session.getDataSource(), e1)) {
                                throw (SQLException)e1;
                            }
                            preparedStatement.setCharacterStream(paramIndex, this.tmpReader, (int)streamLength);
                        }
                    }
                    break block12;
                }
                if (this.clob != null) {
                    preparedStatement.setClob(paramIndex, this.clob);
                } else {
                    preparedStatement.setNull(paramIndex, 2005);
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
            catch (Throwable e) {
                throw new DBCException("IO error while binding content", e);
            }
        }
    }

    public Object getRawValue() {
        return this.clob;
    }

    public boolean isNull() {
        return this.clob == null && this.storage == null;
    }

    @Override
    protected JDBCContentLOB createNewContent() {
        return new JDBCContentCLOB(this.executionContext, null);
    }

    public String getDisplayString(@NotNull DBDDisplayFormat format) {
        if (this.clob == null && this.storage == null) {
            return null;
        }
        if (this.storage != null) {
            if (this.storage instanceof DBDContentCached) {
                return CommonUtils.toString((Object)((DBDContentCached)this.storage).getCachedValue());
            }
            if (this.storage instanceof ExternalContentStorage) {
                return "[" + String.valueOf(((ExternalContentStorage)this.storage).getFile().getFileName()) + "]";
            }
        }
        return "[CLOB]";
    }
}

