/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingContainer;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingType;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ValueFormatSelector;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class StreamConsumerPageSettings
extends DataTransferPageNodeSettings {
    private static final Log log = Log.getLog(StreamConsumerPageSettings.class);
    private static final int EXTRACT_LOB_SKIP = 0;
    private static final int EXTRACT_LOB_FILES = 1;
    private static final int EXTRACT_LOB_INLINE = 2;
    private static final int LOB_ENCODING_BASE64 = 0;
    private static final int LOB_ENCODING_HEX = 1;
    private static final int LOB_ENCODING_BINARY = 2;
    private static final int LOB_ENCODING_NATIVE = 3;
    private PropertyTreeViewer propsEditor;
    private Combo lobExtractType;
    private Label lobEncodingLabel;
    private Combo lobEncodingCombo;
    private Combo formatProfilesCombo;
    private PropertySourceCustom propertySource;
    private ValueFormatSelector valueFormatSelector;

    public StreamConsumerPageSettings() {
        super(DTMessages.data_transfer_wizard_settings_name);
        this.setTitle(DTUIMessages.stream_consumer_page_settings_title);
        this.setDescription(DTUIMessages.stream_consumer_page_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(final Composite parent) {
        final DBPDataFormatterRegistry dataFormatterRegistry = DBPPlatformDesktop.getInstance().getDataFormatterRegistry();
        this.initializeDialogUnits((Control)parent);
        final StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite generalSettings = UIUtils.createComposite((Composite)composite, (int)3);
        this.formatProfilesCombo = UIUtils.createLabelCombo((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_settings_label_formatting, (int)12);
        GridData gd = new GridData(32);
        this.formatProfilesCombo.setLayoutData((Object)gd);
        this.formatProfilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StreamConsumerPageSettings.this.formatProfilesCombo.getSelectionIndex() > 0) {
                    settings.setFormatterProfile(dataFormatterRegistry.getCustomProfile(UIUtils.getComboSelection((Combo)StreamConsumerPageSettings.this.formatProfilesCombo)));
                } else {
                    settings.setFormatterProfile(null);
                }
            }
        });
        Button editProfileButton = UIUtils.createDialogButton((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_settings_button_edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog propDialog = PreferencesUtil.createPropertyDialogOn((Shell)StreamConsumerPageSettings.this.getShell(), (Object)dataFormatterRegistry, (String)"org.jkiss.dbeaver.preferences.main.dataformat", null, (Object)StreamConsumerPageSettings.this.getSelectedFormatterProfile(), (int)0);
                if (propDialog != null) {
                    propDialog.open();
                    StreamConsumerPageSettings.this.reloadFormatProfiles();
                }
            }
        });
        editProfileButton.setEnabled(true);
        this.reloadFormatProfiles();
        ExpandableComposite generalExpander = new ExpandableComposite(composite, 0, 4);
        generalExpander.setLayoutData((Object)new GridData(4, 1, true, false));
        generalExpander.setText(UIConnectionMessages.dialog_connection_advanced_settings);
        generalExpander.addExpansionListener((IExpansionListener)new ExpansionAdapter(this){

            public void expansionStateChanged(ExpansionEvent e) {
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        Composite generalSettings2 = UIUtils.createComposite((Composite)generalExpander, (int)5);
        UIUtils.createControlLabel((Composite)generalSettings2, (String)DTMessages.data_transfer_wizard_settings_group_general, (int)5);
        generalExpander.setClient((Control)generalSettings2);
        UIUtils.createControlLabel((Composite)generalSettings2, (String)DTMessages.data_transfer_wizard_settings_label_binaries);
        Composite binariesPanel = UIUtils.createComposite((Composite)generalSettings2, (int)4);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 4;
        binariesPanel.setLayoutData((Object)gd2);
        this.lobExtractType = new Combo(binariesPanel, 12);
        this.lobExtractType.setItems(new String[]{DTMessages.data_transfer_wizard_settings_binaries_item_set_to_null, DTMessages.data_transfer_wizard_settings_binaries_item_save_to_file, DTMessages.data_transfer_wizard_settings_binaries_item_inline});
        this.lobExtractType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (StreamConsumerPageSettings.this.lobExtractType.getSelectionIndex()) {
                    case 0: {
                        settings.setLobExtractType(StreamConsumerSettings.LobExtractType.SKIP);
                        break;
                    }
                    case 1: {
                        settings.setLobExtractType(StreamConsumerSettings.LobExtractType.FILES);
                        break;
                    }
                    case 2: {
                        settings.setLobExtractType(StreamConsumerSettings.LobExtractType.INLINE);
                    }
                }
                StreamConsumerPageSettings.this.updatePageCompletion();
            }
        });
        this.lobEncodingLabel = UIUtils.createControlLabel((Composite)binariesPanel, (String)DTMessages.data_transfer_wizard_settings_label_encoding);
        this.lobEncodingCombo = new Combo(binariesPanel, 12);
        this.lobEncodingCombo.setItems(new String[]{"Base64", "Hex", "Binary", "Native"});
        this.lobEncodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (StreamConsumerPageSettings.this.lobEncodingCombo.getSelectionIndex()) {
                    case 0: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.BASE64);
                        break;
                    }
                    case 1: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.HEX);
                        break;
                    }
                    case 2: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.BINARY);
                        break;
                    }
                    case 3: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.NATIVE);
                    }
                }
            }
        });
        this.valueFormatSelector = new ValueFormatSelector(generalSettings2);
        this.valueFormatSelector.select(settings.getValueFormat());
        this.valueFormatSelector.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setValueFormat(StreamConsumerPageSettings.this.valueFormatSelector.getSelection());
            }
        });
        this.valueFormatSelector.getCombo().setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
        UIUtils.createControlLabel((Composite)generalSettings2, (String)DTUIMessages.stream_consumer_page_mapping_label_configure);
        UIUtils.createDialogButton((Composite)generalSettings2, (String)DTUIMessages.stream_consumer_page_mapping_button_configure, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ArrayList<StreamMappingContainer> mappings = new ArrayList<StreamMappingContainer>();
                try {
                    UIUtils.runInProgressDialog(monitor -> StreamConsumerPageSettings.this.refreshMappings(monitor, mappings));
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError(DTMessages.stream_transfer_consumer_title_configuration_load_failed, DTMessages.stream_transfer_consumer_message_cannot_load_configuration, (Throwable)e);
                }
                new ConfigureColumnsPopup(StreamConsumerPageSettings.this.getShell(), mappings, settings).open();
            }
        });
        Composite exporterSettings = UIUtils.createComposite((Composite)composite, (int)1);
        exporterSettings.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)exporterSettings, (String)DTMessages.data_transfer_wizard_settings_group_exporter);
        this.propsEditor = new PropertyTreeViewer(exporterSettings, 2048);
        this.propsEditor.getControl().setLayoutData((Object)GridDataFactory.create((int)1808).hint(200, 150).create());
        this.setControl((Control)composite);
    }

    private Object getSelectedFormatterProfile() {
        DBPDataFormatterRegistry registry = DBPPlatformDesktop.getInstance().getDataFormatterRegistry();
        int selectionIndex = this.formatProfilesCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        if (selectionIndex == 0) {
            return registry.getGlobalProfile();
        }
        return registry.getCustomProfile(UIUtils.getComboSelection((Combo)this.formatProfilesCombo));
    }

    private void reloadFormatProfiles() {
        DBPDataFormatterRegistry registry = DBPPlatformDesktop.getInstance().getDataFormatterRegistry();
        this.formatProfilesCombo.removeAll();
        this.formatProfilesCombo.add(DTMessages.data_transfer_wizard_settings_listbox_formatting_item_default);
        for (DBDDataFormatterProfile profile : registry.getCustomProfiles()) {
            this.formatProfilesCombo.add(profile.getProfileName());
        }
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        DBDDataFormatterProfile formatterProfile = settings.getFormatterProfile();
        if (formatterProfile != null) {
            if (!UIUtils.setComboSelection((Combo)this.formatProfilesCombo, (String)formatterProfile.getProfileName())) {
                this.formatProfilesCombo.select(0);
            }
        } else {
            this.formatProfilesCombo.select(0);
        }
    }

    public void activatePage() {
        ((DataTransferWizard)this.getWizard()).loadNodeSettings();
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        this.propertySource = new PropertySourceCustom(processor.getProperties(), ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        switch (settings.getLobExtractType()) {
            case SKIP: {
                this.lobExtractType.select(0);
                break;
            }
            case FILES: {
                this.lobExtractType.select(1);
                break;
            }
            case INLINE: {
                this.lobExtractType.select(2);
            }
        }
        switch (settings.getLobEncoding()) {
            case BASE64: {
                this.lobEncodingCombo.select(0);
                break;
            }
            case HEX: {
                this.lobEncodingCombo.select(1);
                break;
            }
            case BINARY: {
                this.lobEncodingCombo.select(2);
                break;
            }
            case NATIVE: {
                this.lobEncodingCombo.select(3);
            }
        }
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        this.propsEditor.saveEditorValues();
        ((DataTransferWizard)this.getWizard()).getSettings().setProcessorProperties(this.propertySource.getPropertiesWithDefaults());
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        int selectionIndex = this.lobExtractType.getSelectionIndex();
        if (selectionIndex == 2) {
            this.lobEncodingLabel.setVisible(true);
            this.lobEncodingCombo.setVisible(true);
        } else {
            this.lobEncodingLabel.setVisible(false);
            this.lobEncodingCombo.setVisible(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMappings(@NotNull DBRProgressMonitor monitor, @NotNull List<StreamMappingContainer> mappings) {
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        List pipes = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes();
        try {
            monitor.beginTask("Load mappings", pipes.size());
            for (DataTransferPipe pipe : pipes) {
                DBSDataContainer source = (DBSDataContainer)pipe.getProducer().getDatabaseObject();
                StreamMappingContainer mapping = settings.getDataMapping(source);
                if (mapping == null) {
                    mapping = new StreamMappingContainer(source);
                    for (StreamMappingAttribute attribute : mapping.getAttributes(monitor)) {
                        attribute.setMappingType(StreamMappingType.export);
                    }
                } else {
                    mapping = new StreamMappingContainer(mapping);
                }
                mappings.add(mapping);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isPageApplicable() {
        return this.isConsumerOfType(StreamTransferConsumer.class);
    }

    private static class ConfigureColumnsPopup
    extends BaseDialog {
        private final List<StreamMappingContainer> mappings;
        private final StreamConsumerSettings settings;
        private TreeViewer viewer;
        private CLabel errorLabel;

        public ConfigureColumnsPopup(@NotNull Shell shell, @NotNull List<StreamMappingContainer> mappings, @NotNull StreamConsumerSettings settings) {
            super(shell, DTUIMessages.stream_consumer_page_mapping_title, null);
            this.settings = settings;
            this.setShellStyle(66608);
            this.mappings = mappings;
        }

        @NotNull
        protected Composite createDialogArea(@NotNull Composite parent) {
            Composite group = super.createDialogArea(parent);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 300;
            gd.heightHint = 200;
            Composite composite = UIUtils.createComposite((Composite)group, (int)1);
            composite.setLayoutData((Object)gd);
            this.viewer = new TreeViewer(composite, 67586);
            this.viewer.getTree().setLayoutData((Object)new GridData(1808));
            this.viewer.getTree().setLinesVisible(false);
            this.viewer.getTree().setHeaderVisible(true);
            this.viewer.getTree().setLayoutData((Object)gd);
            this.viewer.setContentProvider((IContentProvider)new TreeContentProvider(this){

                public Object[] getChildren(Object element) {
                    return ((StreamMappingContainer)element).getAttributes((DBRProgressMonitor)new VoidProgressMonitor()).toArray();
                }

                public boolean hasChildren(Object element) {
                    return element instanceof StreamMappingContainer;
                }
            });
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, 16384);
            column.setLabelProvider(new CellLabelProvider(this){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    DBPNamedObject object = (DBPNamedObject)element;
                    cell.setText(object.getName());
                    cell.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)object)));
                }
            });
            column.getColumn().setText(DTUIMessages.stream_consumer_page_mapping_name_column_name);
            column = new TreeViewerColumn(this.viewer, 16384);
            column.setLabelProvider(new CellLabelProvider(this){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof StreamMappingAttribute) {
                        StreamMappingAttribute attribute = (StreamMappingAttribute)element;
                        cell.setText(attribute.getMappingType().name());
                        cell.setBackground(attribute.getContainer().isComplete() ? null : UIUtils.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                    } else if (element instanceof StreamMappingContainer) {
                        StreamMappingContainer container = (StreamMappingContainer)element;
                        StreamMappingType type = container.getMappingType();
                        cell.setText(type != null ? type.name() : "");
                        cell.setBackground(container.isComplete() ? null : UIUtils.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                    }
                }
            });
            column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

                protected CellEditor getCellEditor(Object element) {
                    String[] items = new String[]{StreamMappingType.export.name(), StreamMappingType.skip.name()};
                    return new CustomComboBoxCellEditor((ColumnViewer)viewer, (Composite)viewer.getTree(), items, 12);
                }

                protected boolean canEdit(Object element) {
                    return true;
                }

                protected Object getValue(Object element) {
                    if (element instanceof StreamMappingAttribute) {
                        StreamMappingAttribute attribute = (StreamMappingAttribute)element;
                        return attribute.getMappingType().name();
                    }
                    if (element instanceof StreamMappingContainer) {
                        StreamMappingContainer container = (StreamMappingContainer)element;
                        StreamMappingType type = container.getMappingType();
                        return type != null ? type.name() : null;
                    }
                    return null;
                }

                protected void setValue(Object element, Object value) {
                    if (((String)value).isEmpty()) {
                        return;
                    }
                    StreamMappingType type = StreamMappingType.valueOf((String)value.toString());
                    if (element instanceof StreamMappingAttribute) {
                        StreamMappingAttribute attribute = (StreamMappingAttribute)element;
                        attribute.setMappingType(type);
                    } else if (element instanceof StreamMappingContainer) {
                        StreamMappingContainer container = (StreamMappingContainer)element;
                        container.setMappingType(type);
                    }
                    viewer.refresh();
                    this.updateCompletion();
                }
            });
            column.getColumn().setText(DTUIMessages.stream_consumer_page_mapping_mapping_column_name);
            this.errorLabel = new CLabel(group, 0);
            this.errorLabel.setText(DTUIMessages.stream_consumer_page_mapping_label_error_no_columns_selected_text);
            this.errorLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_ERROR));
            this.errorLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            UIUtils.asyncExec(() -> {
                this.viewer.setInput(this.mappings);
                this.viewer.expandAll(true);
                UIUtils.packColumns((Tree)this.viewer.getTree(), (boolean)true, (float[])new float[]{0.75f, 0.25f});
                this.updateCompletion();
            });
            return group;
        }

        protected void okPressed() {
            this.settings.getDataMappings().clear();
            for (StreamMappingContainer mapping : this.mappings) {
                this.settings.addDataMapping(mapping);
            }
            super.okPressed();
        }

        private void updateCompletion() {
            boolean isComplete = this.mappings.stream().allMatch(StreamMappingContainer::isComplete);
            Button okButton = this.getButton(0);
            this.errorLabel.setVisible(!isComplete);
            okButton.setEnabled(isComplete);
        }
    }
}

