/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.ColumnsMappingDialog;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.DatabaseConsumerPageMapping;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ConfigureMetadataStructureDialog
extends BaseDialog {
    private final DataTransferWizard wizard;
    private final DatabaseConsumerSettings settings;
    private final DatabaseMappingContainer mapping;
    private DBSObject tableObject;
    private CTabFolder configTabs;
    private final DatabaseConsumerPageMapping pageMapping;
    private UIServiceSQL serviceSQL;
    private Object sqlPanel;
    private DBEPersistAction[] persistActions;
    private boolean ddlTabNeedRefresh = true;
    private PropertySourceEditable propertySource;

    public ConfigureMetadataStructureDialog(@NotNull DataTransferWizard wizard, @NotNull DatabaseConsumerSettings settings, @NotNull DatabaseMappingContainer mapping, @NotNull DatabaseConsumerPageMapping pageMapping) {
        super(wizard.getShell(), DTUIMessages.page_configure_metadata_title, null);
        this.wizard = wizard;
        this.settings = settings;
        this.mapping = mapping;
        this.pageMapping = pageMapping;
    }

    protected Composite createDialogArea(Composite parent) {
        DBSObjectContainer container;
        Composite composite = super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.configTabs = new CTabFolder(composite, 0x800080);
        this.configTabs.setLayoutData((Object)new GridData(1808));
        CTabItem columnsMappingTab = new CTabItem(this.configTabs, 0);
        columnsMappingTab.setText(DTUIMessages.columns_mapping_dialog_shell_text);
        ColumnsMappingDialog columnsMappingDialog = new ColumnsMappingDialog(this.settings, this.mapping);
        columnsMappingDialog.createControl((Composite)this.configTabs);
        columnsMappingTab.setData((Object)columnsMappingDialog);
        Control pageControl = columnsMappingDialog.getControl();
        columnsMappingTab.setControl(pageControl);
        if (!this.mapping.hasNewTargetObject()) {
            this.tableObject = this.mapping.getTarget();
        }
        if ((container = this.settings.getContainer()) != null && this.mapping.hasNewTargetObject()) {
            CTabItem tablePropertiesTab = new CTabItem(this.configTabs, 0);
            tablePropertiesTab.setText(DTUIMessages.page_configure_table_properties_tab_title);
            DBPDataSource dataSource = container.getDataSource();
            DBCExecutionContext executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
            try {
                this.wizard.getRunnableContext().run(true, true, monitor -> {
                    monitor.beginTask("Generate new table object", 1);
                    try {
                        this.tableObject = DatabaseTransferUtils.generateStructTableDDL((DBRProgressMonitor)monitor, (DBCExecutionContext)executionContext, (DBSObjectContainer)container, (DatabaseMappingContainer)this.mapping, new ArrayList(), (Map)this.mapping.getChangedPropertiesMap());
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                    monitor.done();
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_target_table, DTUIMessages.database_consumer_page_mapping_message_error_generating_target_table, (Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.tableObject != null) {
                this.propertySource = new PropertySourceEditable(null, (Object)this.tableObject, (Object)this.tableObject);
                this.propertySource.collectProperties();
                for (DBPPropertyDescriptor prop : this.propertySource.getProperties()) {
                    ObjectPropertyDescriptor obj;
                    if (!(prop instanceof ObjectPropertyDescriptor) || (obj = (ObjectPropertyDescriptor)prop).isEditPossible((Object)this.tableObject) && !obj.isNameProperty()) continue;
                    this.propertySource.removeProperty(prop);
                }
                if (!ArrayUtils.isEmpty((Object[])this.propertySource.getProperties())) {
                    if (!CommonUtils.isEmpty((Map)this.mapping.getChangedPropertiesMap())) {
                        this.propertySource.setChangedPropertiesMap(this.mapping.getChangedPropertiesMap());
                    } else if (!CommonUtils.isEmpty((Map)this.mapping.getRawChangedPropertiesMap())) {
                        Map rawChangedPropertiesMap = this.mapping.getRawChangedPropertiesMap();
                        for (Map.Entry entry : rawChangedPropertiesMap.entrySet()) {
                            DBPPropertyDescriptor property = this.propertySource.getProperty((String)entry.getKey());
                            if (property == null) continue;
                            this.propertySource.addChangedProperties(property, entry.getValue());
                        }
                        DatabaseTransferUtils.applyPropertyChanges(null, (Map)this.propertySource.getChangedPropertiesValues(), null, null, (DBSEntity)((DBSEntity)this.tableObject));
                    }
                    Composite propertiesComposite = new Composite((Composite)this.configTabs, 0);
                    propertiesComposite.setLayout((Layout)new GridLayout(1, false));
                    propertiesComposite.setLayoutData((Object)gd);
                    UIUtils.createLabel((Composite)propertiesComposite, (String)DTUIMessages.page_configure_table_properties_text);
                    PropertyTreeViewer propertyViewer = new PropertyTreeViewer(propertiesComposite, 2048);
                    propertyViewer.getControl().setLayoutData((Object)gd);
                    propertyViewer.loadProperties((DBPPropertySource)this.propertySource);
                    propertyViewer.changeColumnsWidth();
                    tablePropertiesTab.setControl((Control)propertiesComposite);
                } else {
                    this.createCompositeWithMessage(gd, tablePropertiesTab, DTUIMessages.page_configure_table_properties_no_properties);
                }
            } else {
                this.createCompositeWithMessage(gd, tablePropertiesTab, DTUIMessages.page_configure_table_properties_info_text);
            }
        }
        CTabItem showDDLTab = new CTabItem(this.configTabs, 0);
        showDDLTab.setText(DTMessages.data_transfer_wizard_page_ddl_name);
        this.showDDL(showDDLTab);
        this.configTabs.setSelection(0);
        this.configTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigureMetadataStructureDialog.this.ddlTabNeedRefresh) {
                    DBSObjectContainer container;
                    int selectionIndex = ConfigureMetadataStructureDialog.this.configTabs.getSelectionIndex();
                    Control[] tabList = ConfigureMetadataStructureDialog.this.configTabs.getTabList();
                    if (tabList.length > 0 && selectionIndex == tabList.length - 1 && (container = ConfigureMetadataStructureDialog.this.settings.getContainer()) != null) {
                        DBPDataSource dataSource = container.getDataSource();
                        ConfigureMetadataStructureDialog.this.setNewTextToDDLTab(container, dataSource);
                    }
                }
            }
        });
        return composite;
    }

    private void createCompositeWithMessage(GridData gd, CTabItem tablePropertiesTab, String message) {
        Composite compositeEmpty = new Composite((Composite)this.configTabs, 0);
        compositeEmpty.setLayout((Layout)new GridLayout(1, false));
        compositeEmpty.setLayoutData((Object)gd);
        Composite panel = UIUtils.createPlaceholder((Composite)compositeEmpty, (int)1);
        panel.setLayoutData((Object)gd);
        Text messageText = new Text(panel, 2632);
        messageText.setLayoutData((Object)gd);
        messageText.setText(message);
        tablePropertiesTab.setControl((Control)compositeEmpty);
    }

    private void showDDL(@NotNull CTabItem showDDLTab) {
        final DBSObjectContainer container = this.settings.getContainer();
        if (container == null) {
            return;
        }
        Composite viewerComposite = new Composite((Composite)this.configTabs, 2048);
        viewerComposite.setLayoutData((Object)new GridData(768));
        viewerComposite.setLayout((Layout)new GridLayout(1, false));
        Composite panel = UIUtils.createPlaceholder((Composite)viewerComposite, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        Composite editorPH = new Composite(panel, 2048);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 100;
        gd.minimumWidth = 100;
        editorPH.setLayoutData((Object)gd);
        editorPH.setLayout((Layout)new FillLayout());
        DBPDataSource dataSource = container.getDataSource();
        this.persistActions = this.generateTablePersistActions(container, dataSource);
        this.serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (this.serviceSQL != null) {
            boolean showSaveButton;
            String dialogText;
            if (dataSource != null && dataSource.getInfo().isDynamicMetadata()) {
                dialogText = DTUIMessages.database_consumer_page_mapping_sqlviewer_nonsql_tables_message;
                showSaveButton = false;
                this.ddlTabNeedRefresh = false;
            } else if (ArrayUtils.isEmpty((Object[])this.persistActions)) {
                dialogText = DTUIMessages.database_consumer_page_mapping_error_no_schema_changes_info;
                showSaveButton = false;
            } else {
                dialogText = SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])this.persistActions, (boolean)false);
                showSaveButton = dataSource != null && dataSource.getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA);
            }
            try {
                this.sqlPanel = this.serviceSQL.createSQLPanel((Object)UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), (Object)editorPH, (DBPContextProvider)new DataSourceContextProvider((DBSObject)container), DTUIMessages.database_consumer_page_mapping_sqlviewer_title, false, dialogText);
                this.serviceSQL.setSQLPanelText(this.sqlPanel, dialogText);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Can't create SQL panel", "Error creating SQL panel", (Throwable)e);
            }
            Composite buttonsBar = UIUtils.createComposite((Composite)viewerComposite, (int)2);
            buttonsBar.setLayoutData((Object)new GridData(8));
            GridData gridData = new GridData(1808);
            gridData.minimumHeight = 25;
            gridData.minimumWidth = 100;
            if (showSaveButton) {
                Button persistButton = UIUtils.createPushButton((Composite)buttonsBar, (String)DTUIMessages.page_configure_table_DDL_button_execute, null);
                persistButton.setLayoutData((Object)gridData);
                persistButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (UIUtils.confirmAction((Shell)ConfigureMetadataStructureDialog.this.getShell(), (String)DTUIMessages.database_consumer_page_mapping_create_target_object_confirmation_title, (String)DTUIMessages.database_consumer_page_mapping_create_target_object_confirmation_question)) {
                            if (ConfigureMetadataStructureDialog.this.applySchemaChanges(container, ConfigureMetadataStructureDialog.this.mapping)) {
                                ConfigureMetadataStructureDialog.this.pageMapping.autoAssignMappings();
                            }
                            ConfigureMetadataStructureDialog.this.close();
                        }
                    }
                });
            }
            Button copyButton = UIUtils.createPushButton((Composite)buttonsBar, (String)DTUIMessages.page_configure_table_DDL_button_copy, null);
            copyButton.setLayoutData((Object)gridData);
            copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)dialogText);
                }
            });
            showDDLTab.setControl((Control)viewerComposite);
        }
    }

    @Nullable
    private DBEPersistAction[] generateTablePersistActions(DBSObjectContainer container, DBPDataSource dataSource) {
        DBEPersistAction[][] ddl = new DBEPersistAction[1][];
        try {
            this.wizard.getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask(DTUIMessages.database_consumer_page_mapping_monitor_task, 1);
                try {
                    DBCExecutionContext executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
                    ddl[0] = DatabaseTransferUtils.generateTargetTableDDL((DBRProgressMonitor)monitor, (DBCExecutionContext)executionContext, (DBSObjectContainer)container, (DatabaseMappingContainer)this.mapping, (Map)(this.propertySource != null ? this.propertySource.getChangedPropertiesValues() : this.mapping.getChangedPropertiesMap()));
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_target_DDL, DTUIMessages.database_consumer_page_mapping_message_error_generating_target_DDL, (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return ddl[0];
    }

    private boolean applySchemaChanges(@NotNull DBSObjectContainer targetContainer, @NotNull DatabaseMappingContainer mapping) {
        try {
            this.wizard.getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask("Save schema changes in the database", 1);
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)targetContainer, (String)"Apply schema changes");){
                    DatabaseTransferUtils.executeDDL((DBCSession)session, (DBEPersistAction[])this.persistActions);
                    if (this.settings != null) {
                        DatabaseTransferUtils.refreshDatabaseModel((DBRProgressMonitor)monitor, (DatabaseConsumerSettings)this.settings, (DatabaseMappingContainer)mapping);
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_error_schema_save_title, DTUIMessages.database_consumer_page_mapping_error_schema_save_info, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private void setNewTextToDDLTab(DBSObjectContainer container, DBPDataSource dataSource) {
        this.persistActions = this.generateTablePersistActions(container, dataSource);
        String dialogText = ArrayUtils.isEmpty((Object[])this.persistActions) ? DTUIMessages.database_consumer_page_mapping_error_no_schema_changes_info : SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])this.persistActions, (boolean)false);
        if (this.serviceSQL != null) {
            this.serviceSQL.setSQLPanelText(this.sqlPanel, dialogText);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        Map changedPropertiesValues;
        if (this.propertySource != null && !CommonUtils.isEmpty((Map)(changedPropertiesValues = this.propertySource.getChangedPropertiesValues()))) {
            this.mapping.setChangedPropertiesMap(changedPropertiesValues);
        }
        super.okPressed();
    }
}

