"use strict";
exports.__esModule = true;
exports.getWorkingDirectoryFromHandle = exports.getWorkingDirectoryFromPID = void 0;
var fs = require("fs");
var native;
function getNative() {
    if (!native) {
        native = require('./build/Release/native-process-working-directory.node');
    }
    return native;
}
function cleanupPath(path) {
    if (!path) {
        return null;
    }
    if (path.charCodeAt(path.length - 1) < 32) {
        path = path.substring(0, path.length - 1);
    }
    return path;
}
function getWorkingDirectoryFromPID(pid) {
    if (process.platform === 'linux') {
        return fs.readlinkSync("/proc/" + pid + "/cwd");
    }
    return cleanupPath(getNative().getWorkingDirectoryFromPID(pid));
}
exports.getWorkingDirectoryFromPID = getWorkingDirectoryFromPID;
function getWorkingDirectoryFromHandle(handle) {
    if (process.platform !== 'win32') {
        throw new Error('getWorkingDirectoryFromHandle() is only available on Windows');
    }
    return cleanupPath(getNative().getWorkingDirectoryFromHandle(handle));
}
exports.getWorkingDirectoryFromHandle = getWorkingDirectoryFromHandle;
